/*
 * Copyright (c) 2017-2021 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

/*
 *  extern int cpu_copy_in_cksum(const void *src, void *dst, uint32_t len,
 *	uint32_t initial_sum);
 *
 *  input :
 *      src : source starting address
 *      dst : destination starting address
 *      len : byte stream length
 *      initial_sum : 32bit sum
 *
 *  output :
 *      the source byte stream is copied into the destination buffer
 *      the function returns the final 16bit checksum
 */

#ifdef __x86_64__
#include "../../../bsd/dev/i386/cpu_copy_in_cksum.s"
#elif defined(__arm64__)
#include "../../../bsd/dev/arm64/cpu_copy_in_cksum.s"
#elif defined(__arm__)
#include "../../../bsd/dev/arm/cpu_copy_in_cksum.s"
#elif defined(__i386__)
/* This is dealt with by the reference C code */
#else
#error "Unsupported architecture"
#endif
