/*
 * Copyright (c) 2019 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
#ifndef _INSTRUCTIONS_H_
#define _INSTRUCTIONS_H_

#define ARM64_INSTR_CAS_MASK          (0x3fa07c00)
#define ARM64_INSTR_CAS_BITS          (0x08a07c00)
#define ARM64_INSTR_IS_CAS(x)         (((x) & ARM64_INSTR_CAS_MASK) == ARM64_INSTR_CAS_BITS)

#define ARM64_INSTR_CAS_SZ_MASK   0x3
#define ARM64_INSTR_CAS_SZ_SHIFT  30
#define ARM64_INSTR_CAS_SZ_GET(x) (((x) >> ARM64_INSTR_CAS_SZ_SHIFT) & ARM64_INSTR_CAS_SZ_MASK)

#define ARM64_INSTR_CAS_A_MASK    0x1
#define ARM64_INSTR_CAS_A_SHIFT   22
#define ARM64_INSTR_CAS_A_GET(x)  (((x) >> ARM64_INSTR_CAS_A_SHIFT) & ARM64_INSTR_CAS_A_MASK)

#define ARM64_INSTR_CAS_RS_MASK   0x1f
#define ARM64_INSTR_CAS_RS_SHIFT  16
#define ARM64_INSTR_CAS_RS_GET(x) (((x) >> ARM64_INSTR_CAS_RS_SHIFT) & ARM64_INSTR_CAS_RS_MASK)

#define ARM64_INSTR_CAS_R_MASK    0x1
#define ARM64_INSTR_CAS_R_SHIFT   15
#define ARM64_INSTR_CAS_R_GET(x)  (((x) >> ARM64_INSTR_CAS_R_SHIFT) & ARM64_INSTR_CAS_R_MASK)

#define ARM64_INSTR_CAS_RN_MASK   0x1f
#define ARM64_INSTR_CAS_RN_SHIFT  5
#define ARM64_INSTR_CAS_RN_GET(x) (((x) >> ARM64_INSTR_CAS_RN_SHIFT) & ARM64_INSTR_CAS_RN_MASK)

#define ARM64_INSTR_CAS_RT_MASK   0x1f
#define ARM64_INSTR_CAS_RT_SHIFT  0
#define ARM64_INSTR_CAS_RT_GET(x) (((x) >> ARM64_INSTR_CAS_RT_SHIFT) & ARM64_INSTR_CAS_RT_MASK)



#define ARM64_INSTR_CASP_MASK         (0xbfa07c00)
#define ARM64_INSTR_CASP_BITS         (0x08207c00)
#define ARM64_INSTR_IS_CASP(x)        (((x) & ARM64_INSTR_CASP_MASK) == ARM64_INSTR_CASP_BITS)

#define ARM64_INSTR_CASP_SZ_MASK   0x1
#define ARM64_INSTR_CASP_SZ_SHIFT  30
#define ARM64_INSTR_CASP_SZ_GET(x) (((x) >> ARM64_INSTR_CASP_SZ_SHIFT) & ARM64_INSTR_CASP_SZ_MASK)

#define ARM64_INSTR_CASP_A_MASK    0x1
#define ARM64_INSTR_CASP_A_SHIFT   22
#define ARM64_INSTR_CASP_A_GET(x)  (((x) >> ARM64_INSTR_CASP_A_SHIFT) & ARM64_INSTR_CASP_A_MASK)

#define ARM64_INSTR_CASP_RS_MASK   0x1f
#define ARM64_INSTR_CASP_RS_SHIFT  16
#define ARM64_INSTR_CASP_RS_GET(x) (((x) >> ARM64_INSTR_CASP_RS_SHIFT) & ARM64_INSTR_CASP_RS_MASK)

#define ARM64_INSTR_CASP_R_MASK    0x1
#define ARM64_INSTR_CASP_R_SHIFT   15
#define ARM64_INSTR_CASP_R_GET(x)  (((x) >> ARM64_INSTR_CASP_R_SHIFT) & ARM64_INSTR_CASP_R_MASK)

#define ARM64_INSTR_CASP_RN_MASK   0x1f
#define ARM64_INSTR_CASP_RN_SHIFT  5
#define ARM64_INSTR_CASP_RN_GET(x) (((x) >> ARM64_INSTR_CASP_RN_SHIFT) & ARM64_INSTR_CASP_RN_MASK)

#define ARM64_INSTR_CASP_RT_MASK   0x1f
#define ARM64_INSTR_CASP_RT_SHIFT  0
#define ARM64_INSTR_CASP_RT_GET(x) (((x) >> ARM64_INSTR_CASP_RT_SHIFT) & ARM64_INSTR_CASP_RT_MASK)



#define ARM64_INSTR_ATOMIC_LDST_MASK  (0x3f208c00)
#define ARM64_INSTR_ATOMIC_LDST_BITS  (0x38200000)
#define ARM64_INSTR_IS_ATOMIC_LDST(x) (((x) & ARM64_INSTR_ATOMIC_LDST_MASK) == ARM64_INSTR_ATOMIC_LDST_BITS)

#define ARM64_INSTR_ATOMIC_LDST_SZ_MASK   0x3
#define ARM64_INSTR_ATOMIC_LDST_SZ_SHIFT  30
#define ARM64_INSTR_ATOMIC_LDST_SZ_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_SZ_SHIFT) & ARM64_INSTR_ATOMIC_LDST_SZ_MASK)

#define ARM64_INSTR_ATOMIC_LDST_A_MASK    0x1
#define ARM64_INSTR_ATOMIC_LDST_A_SHIFT   23
#define ARM64_INSTR_ATOMIC_LDST_A_GET(x)  (((x) >> ARM64_INSTR_ATOMIC_LDST_A_SHIFT) & ARM64_INSTR_ATOMIC_LDST_A_MASK)

#define ARM64_INSTR_ATOMIC_LDST_R_MASK    0x1
#define ARM64_INSTR_ATOMIC_LDST_R_SHIFT   22
#define ARM64_INSTR_ATOMIC_LDST_R_GET(x)  (((x) >> ARM64_INSTR_ATOMIC_LDST_R_SHIFT) & ARM64_INSTR_ATOMIC_LDST_R_MASK)

#define ARM64_INSTR_ATOMIC_LDST_RS_MASK   0x1f
#define ARM64_INSTR_ATOMIC_LDST_RS_SHIFT  16
#define ARM64_INSTR_ATOMIC_LDST_RS_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_RS_SHIFT) & ARM64_INSTR_ATOMIC_LDST_RS_MASK)

#define ARM64_INSTR_ATOMIC_LDST_OPC_ADD    0
#define ARM64_INSTR_ATOMIC_LDST_OPC_BIC    1
#define ARM64_INSTR_ATOMIC_LDST_OPC_EOR    2
#define ARM64_INSTR_ATOMIC_LDST_OPC_ORR    3
#define ARM64_INSTR_ATOMIC_LDST_OPC_SMAX   4
#define ARM64_INSTR_ATOMIC_LDST_OPC_SMIN   5
#define ARM64_INSTR_ATOMIC_LDST_OPC_UMAX   6
#define ARM64_INSTR_ATOMIC_LDST_OPC_UMIN   7

#define ARM64_INSTR_ATOMIC_LDST_OPC_MASK   0x7
#define ARM64_INSTR_ATOMIC_LDST_OPC_SHIFT  12
#define ARM64_INSTR_ATOMIC_LDST_OPC_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_OPC_SHIFT) & ARM64_INSTR_ATOMIC_LDST_OPC_MASK)

#define ARM64_INSTR_ATOMIC_LDST_RN_MASK   0x1f
#define ARM64_INSTR_ATOMIC_LDST_RN_SHIFT  5
#define ARM64_INSTR_ATOMIC_LDST_RN_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_RN_SHIFT) & ARM64_INSTR_ATOMIC_LDST_RN_MASK)

#define ARM64_INSTR_ATOMIC_LDST_RT_MASK   0x1f
#define ARM64_INSTR_ATOMIC_LDST_RT_SHIFT  0
#define ARM64_INSTR_ATOMIC_LDST_RT_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_RT_SHIFT) & ARM64_INSTR_ATOMIC_LDST_RT_MASK)



#define ARM64_INSTR_SWP_MASK          (0x3f208c00)
#define ARM64_INSTR_SWP_BITS          (0x38208000)
#define ARM64_INSTR_IS_SWP(x)         (((x) & ARM64_INSTR_SWP_MASK) == ARM64_INSTR_SWP_BITS)

#define ARM64_INSTR_SWP_SZ_MASK   0x3
#define ARM64_INSTR_SWP_SZ_SHIFT  30
#define ARM64_INSTR_SWP_SZ_GET(x) (((x) >> ARM64_INSTR_SWP_SZ_SHIFT) & ARM64_INSTR_SWP_SZ_MASK)

#define ARM64_INSTR_SWP_A_MASK    0x1
#define ARM64_INSTR_SWP_A_SHIFT   23
#define ARM64_INSTR_SWP_A_GET(x)  (((x) >> ARM64_INSTR_SWP_A_SHIFT) & ARM64_INSTR_SWP_A_MASK)

#define ARM64_INSTR_SWP_R_MASK    0x1
#define ARM64_INSTR_SWP_R_SHIFT   22
#define ARM64_INSTR_SWP_R_GET(x)  (((x) >> ARM64_INSTR_SWP_R_SHIFT) & ARM64_INSTR_SWP_R_MASK)

#define ARM64_INSTR_SWP_RS_MASK   0x1f
#define ARM64_INSTR_SWP_RS_SHIFT  16
#define ARM64_INSTR_SWP_RS_GET(x) (((x) >> ARM64_INSTR_SWP_RS_SHIFT) & ARM64_INSTR_SWP_RS_MASK)

#define ARM64_INSTR_SWP_OPC_MASK   0x7
#define ARM64_INSTR_SWP_OPC_SHIFT  12
#define ARM64_INSTR_SWP_OPC_GET(x) (((x) >> ARM64_INSTR_SWP_OPC_SHIFT) & ARM64_INSTR_SWP_OPC_MASK)

#define ARM64_INSTR_SWP_RN_MASK   0x1f
#define ARM64_INSTR_SWP_RN_SHIFT  5
#define ARM64_INSTR_SWP_RN_GET(x) (((x) >> ARM64_INSTR_SWP_RN_SHIFT) & ARM64_INSTR_SWP_RN_MASK)

#define ARM64_INSTR_SWP_RT_MASK   0x1f
#define ARM64_INSTR_SWP_RT_SHIFT  0
#define ARM64_INSTR_SWP_RT_GET(x) (((x) >> ARM64_INSTR_SWP_RT_SHIFT) & ARM64_INSTR_SWP_RT_MASK)



#define ARM64_INSTR_AUTxx_MASK          (0xffffd000)
#define ARM64_INSTR_AUTxx_BITS          (0xdac11000)
#define ARM64_INSTR_IS_AUTxx(x)         (((x) & ARM64_INSTR_AUTxx_MASK) == ARM64_INSTR_AUTxx_BITS)

#define ARM64_INSTR_AUTxx_RD_MASK       0x1f
#define ARM64_INSTR_AUTxx_RD_SHIFT      0
#define ARM64_INSTR_AUTxx_RD_GET(x)     (((x) >> ARM64_INSTR_AUTxx_RD_SHIFT) & ARM64_INSTR_AUTxx_RD_MASK)



#define ARM64_INSTR_AUTIx_SYSTEM_MASK                   (0xfffffd9f)
#define ARM64_INSTR_AUTIx_SYSTEM_BITS                   (0xd503219f)
#define ARM64_INSTR_IS_AUTIx_SYSTEM(x)                  (((x) & ARM64_INSTR_AUTIx_SYSTEM_MASK) == ARM64_INSTR_AUTIx_SYSTEM_BITS)

#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_MASK           0x7c
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_SHIFT          0x5
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_GET(x)         (((x) >> ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_SHIFT) & ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_MASK)
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_AUTIA1716      0xc
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_AUTIB1716      0xe


#endif /* _INSTRUCTIONS_H_ */
