#include <sys/sysctl.h>
#include <signal.h>
#include <darwintest.h>
#include <darwintest_utils.h>

T_GLOBAL_META(
	T_META_NAMESPACE("xnu.vm"),
	T_META_RADAR_COMPONENT_NAME("xnu"),
	T_META_RADAR_COMPONENT_VERSION("VM"),
	T_META_ASROOT(YES));

static int64_t
run_sysctl_test(const char *t, int64_t value)
{
	char name[1024];
	int64_t result = 0;
	size_t s = sizeof(value);
	int rc;

	snprintf(name, sizeof(name), "debug.test.%s", t);
	rc = sysctlbyname(name, &result, &s, &value, s);
	T_ASSERT_POSIX_SUCCESS(rc, "sysctlbyname(%s)", t);
	return result;
}

T_DECL(kmem_basic, "General kmem test")
{
	T_EXPECT_EQ(1ull, run_sysctl_test("kmem_basic", 0), "kmem_basic");
}

T_DECL(kmem_guard_obj, "Kmem test guard objects")
{
	T_EXPECT_EQ(1ull, run_sysctl_test("kmem_guard_obj", 0), "kmem_guard_obj");
}
