/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2011 Joyent, Inc.  All rights reserved.
 */

/*
 * This file delivers VMX description that is compatible with DTrace
 * upstream.
 */

enum vmregs_vmx {
	VMX_VIRTUAL_PROCESSOR_ID			= 0x00000000,
	VMX_GUEST_ES_SELECTOR				= 0x00000800,
	VMX_GUEST_CS_SELECTOR				= 0x00000802,
	VMX_GUEST_SS_SELECTOR				= 0x00000804,
	VMX_GUEST_DS_SELECTOR				= 0x00000806,
	VMX_GUEST_FS_SELECTOR				= 0x00000808,
	VMX_GUEST_GS_SELECTOR				= 0x0000080a,
	VMX_GUEST_LDTR_SELECTOR				= 0x0000080c,
	VMX_GUEST_TR_SELECTOR				= 0x0000080e,
	VMX_HOST_ES_SELECTOR				= 0x00000c00,
	VMX_HOST_CS_SELECTOR				= 0x00000c02,
	VMX_HOST_SS_SELECTOR				= 0x00000c04,
	VMX_HOST_DS_SELECTOR				= 0x00000c06,
	VMX_HOST_FS_SELECTOR				= 0x00000c08,
	VMX_HOST_GS_SELECTOR				= 0x00000c0a,
	VMX_HOST_TR_SELECTOR				= 0x00000c0c,
	VMX_IO_BITMAP_A					= 0x00002000,
	VMX_IO_BITMAP_A_HIGH				= 0x00002001,
	VMX_IO_BITMAP_B					= 0x00002002,
	VMX_IO_BITMAP_B_HIGH				= 0x00002003,
	VMX_MSR_BITMAP					= 0x00002004,
	VMX_MSR_BITMAP_HIGH				= 0x00002005,
	VMX_VM_EXIT_MSR_STORE_ADDR			= 0x00002006,
	VMX_VM_EXIT_MSR_STORE_ADDR_HIGH			= 0x00002007,
	VMX_VM_EXIT_MSR_LOAD_ADDR			= 0x00002008,
	VMX_VM_EXIT_MSR_LOAD_ADDR_HIGH			= 0x00002009,
	VMX_VM_ENTRY_MSR_LOAD_ADDR			= 0x0000200a,
	VMX_VM_ENTRY_MSR_LOAD_ADDR_HIGH			= 0x0000200b,
	VMX_TSC_OFFSET					= 0x00002010,
	VMX_TSC_OFFSET_HIGH				= 0x00002011,
	VMX_VIRTUAL_APIC_PAGE_ADDR			= 0x00002012,
	VMX_VIRTUAL_APIC_PAGE_ADDR_HIGH			= 0x00002013,
	VMX_APIC_ACCESS_ADDR				= 0x00002014,
	VMX_APIC_ACCESS_ADDR_HIGH			= 0x00002015,
	VMX_EPT_POINTER					= 0x0000201a,
	VMX_EPT_POINTER_HIGH				= 0x0000201b,
	VMX_GUEST_PHYSICAL_ADDRESS			= 0x00002400,
	VMX_GUEST_PHYSICAL_ADDRESS_HIGH			= 0x00002401,
	VMX_VMCS_LINK_POINTER				= 0x00002800,
	VMX_VMCS_LINK_POINTER_HIGH			= 0x00002801,
	VMX_GUEST_IA32_DEBUGCTL				= 0x00002802,
	VMX_GUEST_IA32_DEBUGCTL_HIGH			= 0x00002803,
	VMX_GUEST_IA32_PAT				= 0x00002804,
	VMX_GUEST_IA32_PAT_HIGH				= 0x00002805,
	VMX_GUEST_PDPTR0				= 0x0000280a,
	VMX_GUEST_PDPTR0_HIGH				= 0x0000280b,
	VMX_GUEST_PDPTR1				= 0x0000280c,
	VMX_GUEST_PDPTR1_HIGH				= 0x0000280d,
	VMX_GUEST_PDPTR2				= 0x0000280e,
	VMX_GUEST_PDPTR2_HIGH				= 0x0000280f,
	VMX_GUEST_PDPTR3				= 0x00002810,
	VMX_GUEST_PDPTR3_HIGH				= 0x00002811,
	VMX_HOST_IA32_PAT				= 0x00002c00,
	VMX_HOST_IA32_PAT_HIGH				= 0x00002c01,
	VMX_PIN_BASED_VM_EXEC_CONTROL			= 0x00004000,
	VMX_CPU_BASED_VM_EXEC_CONTROL			= 0x00004002,
	VMX_EXCEPTION_BITMAP				= 0x00004004,
	VMX_PAGE_FAULT_ERROR_CODE_MASK			= 0x00004006,
	VMX_PAGE_FAULT_ERROR_CODE_MATCH			= 0x00004008,
	VMX_CR3_TARGET_COUNT				= 0x0000400a,
	VMX_VM_EXIT_CONTROLS				= 0x0000400c,
	VMX_VM_EXIT_MSR_STORE_COUNT			= 0x0000400e,
	VMX_VM_EXIT_MSR_LOAD_COUNT			= 0x00004010,
	VMX_VM_ENTRY_CONTROLS				= 0x00004012,
	VMX_VM_ENTRY_MSR_LOAD_COUNT			= 0x00004014,
	VMX_VM_ENTRY_INTR_INFO_FIELD			= 0x00004016,
	VMX_VM_ENTRY_EXCEPTION_ERROR_CODE		= 0x00004018,
	VMX_VM_ENTRY_INSTRUCTION_LEN			= 0x0000401a,
	VMX_TPR_THRESHOLD				= 0x0000401c,
	VMX_SECONDARY_VM_EXEC_CONTROL			= 0x0000401e,
	VMX_PLE_GAP					= 0x00004020,
	VMX_PLE_WINDOW					= 0x00004022,
	VMX_VM_INSTRUCTION_ERROR			= 0x00004400,
	VMX_VM_EXIT_REASON				= 0x00004402,
	VMX_VM_EXIT_INTR_INFO				= 0x00004404,
	VMX_VM_EXIT_INTR_ERROR_CODE			= 0x00004406,
	VMX_IDT_VECTORING_INFO_FIELD			= 0x00004408,
	VMX_IDT_VECTORING_ERROR_CODE			= 0x0000440a,
	VMX_VM_EXIT_INSTRUCTION_LEN			= 0x0000440c,
	VMX_VMX_INSTRUCTION_INFO			= 0x0000440e,
	VMX_GUEST_ES_LIMIT				= 0x00004800,
	VMX_GUEST_CS_LIMIT				= 0x00004802,
	VMX_GUEST_SS_LIMIT				= 0x00004804,
	VMX_GUEST_DS_LIMIT				= 0x00004806,
	VMX_GUEST_FS_LIMIT				= 0x00004808,
	VMX_GUEST_GS_LIMIT				= 0x0000480a,
	VMX_GUEST_LDTR_LIMIT				= 0x0000480c,
	VMX_GUEST_TR_LIMIT				= 0x0000480e,
	VMX_GUEST_GDTR_LIMIT				= 0x00004810,
	VMX_GUEST_IDTR_LIMIT				= 0x00004812,
	VMX_GUEST_ES_AR_BYTES				= 0x00004814,
	VMX_GUEST_CS_AR_BYTES				= 0x00004816,
	VMX_GUEST_SS_AR_BYTES				= 0x00004818,
	VMX_GUEST_DS_AR_BYTES				= 0x0000481a,
	VMX_GUEST_FS_AR_BYTES				= 0x0000481c,
	VMX_GUEST_GS_AR_BYTES				= 0x0000481e,
	VMX_GUEST_LDTR_AR_BYTES				= 0x00004820,
	VMX_GUEST_TR_AR_BYTES				= 0x00004822,
	VMX_GUEST_INTERRUPTIBILITY_INFO			= 0x00004824,
	VMX_GUEST_ACTIVITY_STATE			= 0X00004826,
	VMX_GUEST_SYSENTER_CS				= 0x0000482A,
	VMX_HOST_IA32_SYSENTER_CS			= 0x00004c00,
	VMX_CR0_GUEST_HOST_MASK				= 0x00006000,
	VMX_CR4_GUEST_HOST_MASK				= 0x00006002,
	VMX_CR0_READ_SHADOW				= 0x00006004,
	VMX_CR4_READ_SHADOW				= 0x00006006,
	VMX_CR3_TARGET_VALUE0				= 0x00006008,
	VMX_CR3_TARGET_VALUE1				= 0x0000600a,
	VMX_CR3_TARGET_VALUE2				= 0x0000600c,
	VMX_CR3_TARGET_VALUE3				= 0x0000600e,
	VMX_EXIT_QUALIFICATION				= 0x00006400,
	VMX_GUEST_LINEAR_ADDRESS			= 0x0000640a,
	VMX_GUEST_CR0					= 0x00006800,
	VMX_GUEST_CR3					= 0x00006802,
	VMX_GUEST_CR4					= 0x00006804,
	VMX_GUEST_ES_BASE				= 0x00006806,
	VMX_GUEST_CS_BASE				= 0x00006808,
	VMX_GUEST_SS_BASE				= 0x0000680a,
	VMX_GUEST_DS_BASE				= 0x0000680c,
	VMX_GUEST_FS_BASE				= 0x0000680e,
	VMX_GUEST_GS_BASE				= 0x00006810,
	VMX_GUEST_LDTR_BASE				= 0x00006812,
	VMX_GUEST_TR_BASE				= 0x00006814,
	VMX_GUEST_GDTR_BASE				= 0x00006816,
	VMX_GUEST_IDTR_BASE				= 0x00006818,
	VMX_GUEST_DR7					= 0x0000681a,
	VMX_GUEST_RSP					= 0x0000681c,
	VMX_GUEST_RIP					= 0x0000681e,
	VMX_GUEST_RFLAGS				= 0x00006820,
	VMX_GUEST_PENDING_DBG_EXCEPTIONS		= 0x00006822,
	VMX_GUEST_SYSENTER_ESP				= 0x00006824,
	VMX_GUEST_SYSENTER_EIP				= 0x00006826,
	VMX_HOST_CR0					= 0x00006c00,
	VMX_HOST_CR3					= 0x00006c02,
	VMX_HOST_CR4					= 0x00006c04,
	VMX_HOST_FS_BASE				= 0x00006c06,
	VMX_HOST_GS_BASE				= 0x00006c08,
	VMX_HOST_TR_BASE				= 0x00006c0a,
	VMX_HOST_GDTR_BASE				= 0x00006c0c,
	VMX_HOST_IDTR_BASE				= 0x00006c0e,
	VMX_HOST_IA32_SYSENTER_ESP			= 0x00006c10,
	VMX_HOST_IA32_SYSENTER_EIP			= 0x00006c12,
	VMX_HOST_RSP					= 0x00006c14,
	VMX_HOST_RIP					= 0x00006c16
};

