/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#include <sys/sdt_impl.h>

static dtrace_pattr_t vtrace_attr = {
	{ DTRACE_STABILITY_UNSTABLE, DTRACE_STABILITY_UNSTABLE, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_UNSTABLE, DTRACE_STABILITY_UNSTABLE, DTRACE_CLASS_ISA },
};

static dtrace_pattr_t info_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_ISA },
};

static dtrace_pattr_t fpu_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_CPU },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_ISA },
};

static dtrace_pattr_t fsinfo_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
};

static dtrace_pattr_t stab_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
};

static dtrace_pattr_t sdt_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_ISA },
};

#if defined(__x86_64__) && HYPERVISOR
static dtrace_pattr_t hv_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
};
#endif /* __x86_64__ && HYPERVISOR */

static dtrace_pattr_t sandbox_attr = {
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_PRIVATE, DTRACE_STABILITY_PRIVATE, DTRACE_CLASS_UNKNOWN },
	{ DTRACE_STABILITY_EVOLVING, DTRACE_STABILITY_EVOLVING, DTRACE_CLASS_ISA },
};

sdt_provider_t sdt_providers[] = {
	{ "vtrace", "__vtrace____", &vtrace_attr, 0 },
	{ "sysinfo", "__cpu_sysinfo____", &info_attr, 0 },
	{ "vminfo", "__vminfo____", &info_attr, 0 },
	{ "fpuinfo", "__fpuinfo____", &fpu_attr, 0 },
	{ "sched", "__sched____", &stab_attr, 0 },
	{ "proc", "__proc____", &stab_attr, 0 },
	{ "io", "__io____", &stab_attr, 0 },
	{ "ip", "__ip____", &stab_attr, 0 },
	{ "tcp", "__tcp____", &stab_attr, 0 },
	{ "mptcp", "__mptcp____", &stab_attr, 0 },
	{ "mib", "__mib____", &stab_attr, 0 },
	{ "fsinfo", "__fsinfo____", &fsinfo_attr, 0 },
	{ "nfsv3", "__nfsv3____", &stab_attr, 0 },
	{ "nfsv4", "__nfsv4____", &stab_attr, 0 },
	{ "sysevent", "__sysevent____", &stab_attr, 0 },
	{ "sdt", "__sdt____", &sdt_attr, 0 },
	{ "boost", "__boost____", &stab_attr, 0},
#if SKYWALK
	{ "skywalk", "__skywalk____", &stab_attr, 0},
#endif // SKYWALK
	{ "route", "__route____", &stab_attr, 0 },
#if KASAN
	{ "kasan", "__kasan____", &stab_attr, 0 },
#endif
#if CONFIG_KCOV
	{ "kcov", "__kcov____", &stab_attr, 0},
#endif
#if defined(__x86_64__) && HYPERVISOR
	{ "hv", "__hv____", &hv_attr, 0 },
#endif /* __x86_64__ && HYPERVISOR */
	{ "sandbox", "__sandbox____", &sandbox_attr, 0 },
	{ NULL, NULL, NULL, 0 }
};

/* Warning:  Need xnu cognate for disp_t.  */
sdt_argdesc_t sdt_args[] = {
	/* provider probename arg# arg-mapping native-type translated-type */
	{ "sched", "wakeup", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "wakeup", 1, 1, "struct proc *", "psinfo_t *" },
	{ "sched", "dequeue", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "dequeue", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "dequeue", 2, 1, "disp_t *", "cpuinfo_t *" },
	{ "sched", "enqueue", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "enqueue", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "enqueue", 2, 1, "disp_t *", "cpuinfo_t *" },
	{ "sched", "enqueue", 3, 2, "int", NULL },
	/* sched:::sleep has no arguments */
	/* sched:::on-cpu has no arguments */
	{ "sched", "off-cpu", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "off-cpu", 1, 1, "struct proc *", "psinfo_t *" },
	{ "sched", "tick", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "tick", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "change-pri", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "change-pri", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "change-pri", 2, 1, "pri_t", NULL },
	{ "sched", "schedctl-nopreempt", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "schedctl-nopreempt", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "schedctl-nopreempt", 2, 1, "int", NULL },
	{ "sched", "schedctl-preempt", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "schedctl-preempt", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "schedctl-yield", 0, 0, "int", NULL },
	{ "sched", "surrender", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "sched", "surrender", 1, 0, "struct proc *", "psinfo_t *" },
	{ "sched", "surrender", 1, 0, "kthread_t *", "psinfo_t *" },
	{ "sched", "cpucaps-sleep", 0, 0, "kthread_t *", "lwpsinfo_t *" },
	{ "sched", "cpucaps-sleep", 1, 0, "kthread_t *", "psinfo_t *" },
	{ "sched", "cpucaps-wakeup", 0, 0, "kthread_t *", "lwpsinfo_t *" },
	{ "sched", "cpucaps-wakeup", 1, 0, "kthread_t *", "psinfo_t *" },

	{ "proc", "create", 0, 0, "struct proc *", "psinfo_t *" },
	{ "proc", "exec", 0, 0, "string", NULL },
	{ "proc", "exec-failure", 0, 0, "int", NULL },
	/* proc:::exec-success has no arguments */
	{ "proc", "exit", 0, 0, "int", NULL },
	{ "proc", "exited", 0, 0, "struct proc *", "psinfo_t *"},
	{ "proc", "fault", 0, 0, "int", NULL },
	{ "proc", "fault", 1, 1, "siginfo_t *", NULL },
	{ "proc", "lwp-create", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "proc", "lwp-create", 1, 0, "struct thread *", "psinfo_t *" },
	/* proc:::lwp-start has no arguments */
	/* proc:::lwp-exit has no arguments */
	{ "proc", "signal-clear", 0, 0, "int", NULL },
	{ "proc", "signal-clear", 1, 1, "siginfo_t *", NULL },
	{ "proc", "signal-discard", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "proc", "signal-discard", 1, 1, "struct proc *", "psinfo_t *" },
	{ "proc", "signal-discard", 2, 2, "int", NULL },
	{ "proc", "signal-handle", 0, 0, "int", NULL },
	{ "proc", "signal-handle", 1, 1, "siginfo_t *", NULL },
	{ "proc", "signal-handle", 2, 2, "void (*)(void)", NULL },
	{ "proc", "signal-send", 0, 0, "struct thread *", "lwpsinfo_t *" },
	{ "proc", "signal-send", 1, 1, "struct proc *", "psinfo_t *" },
	{ "proc", "signal-send", 2, 2, "int", NULL },
	/* proc:::spawn-success has no arguments */
	{ "proc", "spawn-failure", 0, 0, "int", NULL },
	{ "proc", "spawn-fd-failure", 0, 0, "int", NULL },
	{ "proc", "spawn-open-failure", 0, 0, "string", NULL },
	{ "proc", "spawn-port-failure", 0, 0, "int", NULL },
	/* proc:::start has no arguments */

	{ "io", "start", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "start", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "start", 2, 0, "struct buf *", "fileinfo_t *" },
	{ "io", "done", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "done", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "done", 2, 0, "struct buf *", "fileinfo_t *" },
	{ "io", "wait-start", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "wait-start", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "wait-start", 2, 0, "struct buf *", "fileinfo_t *" },
	{ "io", "wait-done", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "wait-done", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "wait-done", 2, 0, "struct buf *", "fileinfo_t *" },

	/* APPLE NOTE: add vfs journaling support */
	{ "io", "journal-start", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "journal-start", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "journal-start", 2, 0, "struct buf *", "fileinfo_t *" },
	{ "io", "journal-done", 0, 0, "struct buf *", "bufinfo_t *" },
	{ "io", "journal-done", 1, 0, "struct buf *", "devinfo_t *" },
	{ "io", "journal-done", 2, 0, "struct buf *", "fileinfo_t *" },

	{ "mib", NULL, 0, 0, "int", NULL },

	{ "fsinfo", NULL, 0, 0, "struct vnode *", "fileinfo_t *" },
	{ "fsinfo", NULL, 1, 1, "int", NULL },

	{ "nfsv3", "op-getattr-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-getattr-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-getattr-start", 2, 3, "GETATTR3args *", NULL },
	{ "nfsv3", "op-getattr-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-getattr-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-getattr-done", 2, 3, "GETATTR3res *", NULL },
	{ "nfsv3", "op-setattr-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-setattr-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-setattr-start", 2, 3, "SETATTR3args *", NULL },
	{ "nfsv3", "op-setattr-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-setattr-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-setattr-done", 2, 3, "SETATTR3res *", NULL },
	{ "nfsv3", "op-lookup-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-lookup-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-lookup-start", 2, 3, "LOOKUP3args *", NULL },
	{ "nfsv3", "op-lookup-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-lookup-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-lookup-done", 2, 3, "LOOKUP3res *", NULL },
	{ "nfsv3", "op-access-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-access-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-access-start", 2, 3, "ACCESS3args *", NULL },
	{ "nfsv3", "op-access-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-access-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-access-done", 2, 3, "ACCESS3res *", NULL },
	{ "nfsv3", "op-commit-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-commit-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-commit-start", 2, 3, "COMMIT3args *", NULL },
	{ "nfsv3", "op-commit-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-commit-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-commit-done", 2, 3, "COMMIT3res *", NULL },
	{ "nfsv3", "op-create-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-create-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-create-start", 2, 3, "CREATE3args *", NULL },
	{ "nfsv3", "op-create-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-create-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-create-done", 2, 3, "CREATE3res *", NULL },
	{ "nfsv3", "op-fsinfo-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-fsinfo-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-fsinfo-start", 2, 3, "FSINFO3args *", NULL },
	{ "nfsv3", "op-fsinfo-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-fsinfo-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-fsinfo-done", 2, 3, "FSINFO3res *", NULL },
	{ "nfsv3", "op-fsstat-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-fsstat-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-fsstat-start", 2, 3, "FSSTAT3args *", NULL },
	{ "nfsv3", "op-fsstat-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-fsstat-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-fsstat-done", 2, 3, "FSSTAT3res *", NULL },
	{ "nfsv3", "op-link-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-link-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-link-start", 2, 3, "LINK3args *", NULL },
	{ "nfsv3", "op-link-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-link-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-link-done", 2, 3, "LINK3res *", NULL },
	{ "nfsv3", "op-mkdir-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-mkdir-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-mkdir-start", 2, 3, "MKDIR3args *", NULL },
	{ "nfsv3", "op-mkdir-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-mkdir-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-mkdir-done", 2, 3, "MKDIR3res *", NULL },
	{ "nfsv3", "op-mknod-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-mknod-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-mknod-start", 2, 3, "MKNOD3args *", NULL },
	{ "nfsv3", "op-mknod-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-mknod-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-mknod-done", 2, 3, "MKNOD3res *", NULL },
	{ "nfsv3", "op-null-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-null-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-null-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-null-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-pathconf-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-pathconf-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-pathconf-start", 2, 3, "PATHCONF3args *", NULL },
	{ "nfsv3", "op-pathconf-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-pathconf-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-pathconf-done", 2, 3, "PATHCONF3res *", NULL },
	{ "nfsv3", "op-read-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-read-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-read-start", 2, 3, "READ3args *", NULL },
	{ "nfsv3", "op-read-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-read-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-read-done", 2, 3, "READ3res *", NULL },
	{ "nfsv3", "op-readdir-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readdir-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readdir-start", 2, 3, "READDIR3args *", NULL },
	{ "nfsv3", "op-readdir-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readdir-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readdir-done", 2, 3, "READDIR3res *", NULL },
	{ "nfsv3", "op-readdirplus-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readdirplus-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readdirplus-start", 2, 3, "READDIRPLUS3args *", NULL },
	{ "nfsv3", "op-readdirplus-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readdirplus-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readdirplus-done", 2, 3, "READDIRPLUS3res *", NULL },
	{ "nfsv3", "op-readlink-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readlink-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readlink-start", 2, 3, "READLINK3args *", NULL },
	{ "nfsv3", "op-readlink-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-readlink-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-readlink-done", 2, 3, "READLINK3res *", NULL },
	{ "nfsv3", "op-remove-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-remove-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-remove-start", 2, 3, "REMOVE3args *", NULL },
	{ "nfsv3", "op-remove-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-remove-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-remove-done", 2, 3, "REMOVE3res *", NULL },
	{ "nfsv3", "op-rename-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-rename-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-rename-start", 2, 3, "RENAME3args *", NULL },
	{ "nfsv3", "op-rename-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-rename-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-rename-done", 2, 3, "RENAME3res *", NULL },
	{ "nfsv3", "op-rmdir-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-rmdir-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-rmdir-start", 2, 3, "RMDIR3args *", NULL },
	{ "nfsv3", "op-rmdir-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-rmdir-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-rmdir-done", 2, 3, "RMDIR3res *", NULL },
	{ "nfsv3", "op-setattr-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-setattr-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-setattr-start", 2, 3, "SETATTR3args *", NULL },
	{ "nfsv3", "op-setattr-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-setattr-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-setattr-done", 2, 3, "SETATTR3res *", NULL },
	{ "nfsv3", "op-symlink-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-symlink-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-symlink-start", 2, 3, "SYMLINK3args *", NULL },
	{ "nfsv3", "op-symlink-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-symlink-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-symlink-done", 2, 3, "SYMLINK3res *", NULL },
	{ "nfsv3", "op-write-start", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-write-start", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-write-start", 2, 3, "WRITE3args *", NULL },
	{ "nfsv3", "op-write-done", 0, 0, "struct svc_req *",
	  "conninfo_t *" },
	{ "nfsv3", "op-write-done", 1, 1, "nfsv3oparg_t *",
	  "nfsv3opinfo_t *" },
	{ "nfsv3", "op-write-done", 2, 3, "WRITE3res *", NULL },

	{ "nfsv4", "null-start", 0, 0, "struct svc_req *", "conninfo_t *" },
	{ "nfsv4", "null-done", 0, 0, "struct svc_req *", "conninfo_t *" },
	{ "nfsv4", "compound-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "compound-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "compound-start", 2, 1, "COMPOUND4args *", NULL },
	{ "nfsv4", "compound-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "compound-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "compound-done", 2, 1, "COMPOUND4res *", NULL },
	{ "nfsv4", "op-access-start", 0, 0, "struct compound_state *",
	  "conninfo_t *"},
	{ "nfsv4", "op-access-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-access-start", 2, 1, "ACCESS4args *", NULL },
	{ "nfsv4", "op-access-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-access-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-access-done", 2, 1, "ACCESS4res *", NULL },
	{ "nfsv4", "op-close-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-close-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-close-start", 2, 1, "CLOSE4args *", NULL },
	{ "nfsv4", "op-close-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-close-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-close-done", 2, 1, "CLOSE4res *", NULL },
	{ "nfsv4", "op-commit-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-commit-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-commit-start", 2, 1, "COMMIT4args *", NULL },
	{ "nfsv4", "op-commit-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-commit-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-commit-done", 2, 1, "COMMIT4res *", NULL },
	{ "nfsv4", "op-create-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-create-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-create-start", 2, 1, "CREATE4args *", NULL },
	{ "nfsv4", "op-create-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-create-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-create-done", 2, 1, "CREATE4res *", NULL },
	{ "nfsv4", "op-delegpurge-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-delegpurge-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-delegpurge-start", 2, 1, "DELEGPURGE4args *", NULL },
	{ "nfsv4", "op-delegpurge-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-delegpurge-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-delegpurge-done", 2, 1, "DELEGPURGE4res *", NULL },
	{ "nfsv4", "op-delegreturn-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-delegreturn-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-delegreturn-start", 2, 1, "DELEGRETURN4args *", NULL },
	{ "nfsv4", "op-delegreturn-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-delegreturn-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-delegreturn-done", 2, 1, "DELEGRETURN4res *", NULL },
	{ "nfsv4", "op-getattr-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-getattr-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-getattr-start", 2, 1, "GETATTR4args *", NULL },
	{ "nfsv4", "op-getattr-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-getattr-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-getattr-done", 2, 1, "GETATTR4res *", NULL },
	{ "nfsv4", "op-getfh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-getfh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-getfh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-getfh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-getfh-done", 2, 1, "GETFH4res *", NULL },
	{ "nfsv4", "op-link-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-link-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-link-start", 2, 1, "LINK4args *", NULL },
	{ "nfsv4", "op-link-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-link-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-link-done", 2, 1, "LINK4res *", NULL },
	{ "nfsv4", "op-lock-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lock-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lock-start", 2, 1, "LOCK4args *", NULL },
	{ "nfsv4", "op-lock-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lock-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lock-done", 2, 1, "LOCK4res *", NULL },
	{ "nfsv4", "op-lockt-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lockt-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lockt-start", 2, 1, "LOCKT4args *", NULL },
	{ "nfsv4", "op-lockt-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lockt-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lockt-done", 2, 1, "LOCKT4res *", NULL },
	{ "nfsv4", "op-locku-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-locku-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-locku-start", 2, 1, "LOCKU4args *", NULL },
	{ "nfsv4", "op-locku-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-locku-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-locku-done", 2, 1, "LOCKU4res *", NULL },
	{ "nfsv4", "op-lookup-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lookup-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lookup-start", 2, 1, "LOOKUP4args *", NULL },
	{ "nfsv4", "op-lookup-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lookup-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lookup-done", 2, 1, "LOOKUP4res *", NULL },
	{ "nfsv4", "op-lookupp-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lookupp-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lookupp-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-lookupp-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-lookupp-done", 2, 1, "LOOKUPP4res *", NULL },
	{ "nfsv4", "op-nverify-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-nverify-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-nverify-start", 2, 1, "NVERIFY4args *", NULL },
	{ "nfsv4", "op-nverify-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-nverify-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-nverify-done", 2, 1, "NVERIFY4res *", NULL },
	{ "nfsv4", "op-open-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-start", 2, 1, "OPEN4args *", NULL },
	{ "nfsv4", "op-open-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-done", 2, 1, "OPEN4res *", NULL },
	{ "nfsv4", "op-open-confirm-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-confirm-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-confirm-start", 2, 1, "OPEN_CONFIRM4args *", NULL },
	{ "nfsv4", "op-open-confirm-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-confirm-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-confirm-done", 2, 1, "OPEN_CONFIRM4res *", NULL },
	{ "nfsv4", "op-open-downgrade-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-downgrade-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-downgrade-start", 2, 1, "OPEN_DOWNGRADE4args *", NULL },
	{ "nfsv4", "op-open-downgrade-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-open-downgrade-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-open-downgrade-done", 2, 1, "OPEN_DOWNGRADE4res *", NULL },
	{ "nfsv4", "op-openattr-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-openattr-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-openattr-start", 2, 1, "OPENATTR4args *", NULL },
	{ "nfsv4", "op-openattr-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-openattr-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-openattr-done", 2, 1, "OPENATTR4res *", NULL },
	{ "nfsv4", "op-putfh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putfh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putfh-start", 2, 1, "PUTFH4args *", NULL },
	{ "nfsv4", "op-putfh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putfh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putfh-done", 2, 1, "PUTFH4res *", NULL },
	{ "nfsv4", "op-putpubfh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putpubfh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putpubfh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putpubfh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putpubfh-done", 2, 1, "PUTPUBFH4res *", NULL },
	{ "nfsv4", "op-putrootfh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putrootfh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putrootfh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-putrootfh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-putrootfh-done", 2, 1, "PUTROOTFH4res *", NULL },
	{ "nfsv4", "op-read-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-read-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-read-start", 2, 1, "READ4args *", NULL },
	{ "nfsv4", "op-read-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-read-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-read-done", 2, 1, "READ4res *", NULL },
	{ "nfsv4", "op-readdir-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-readdir-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-readdir-start", 2, 1, "READDIR4args *", NULL },
	{ "nfsv4", "op-readdir-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-readdir-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-readdir-done", 2, 1, "READDIR4res *", NULL },
	{ "nfsv4", "op-readlink-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-readlink-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-readlink-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-readlink-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-readlink-done", 2, 1, "READLINK4res *", NULL },
	{ "nfsv4", "op-release-lockowner-start", 0, 0,
	  "struct compound_state *", "conninfo_t *" },
	{ "nfsv4", "op-release-lockowner-start", 1, 0,
	  "struct compound_state *", "nfsv4opinfo_t *" },
	{ "nfsv4", "op-release-lockowner-start", 2, 1,
	  "RELEASE_LOCKOWNER4args *", NULL },
	{ "nfsv4", "op-release-lockowner-done", 0, 0,
	  "struct compound_state *", "conninfo_t *" },
	{ "nfsv4", "op-release-lockowner-done", 1, 0,
	  "struct compound_state *", "nfsv4opinfo_t *" },
	{ "nfsv4", "op-release-lockowner-done", 2, 1,
	  "RELEASE_LOCKOWNER4res *", NULL },
	{ "nfsv4", "op-remove-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-remove-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-remove-start", 2, 1, "REMOVE4args *", NULL },
	{ "nfsv4", "op-remove-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-remove-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-remove-done", 2, 1, "REMOVE4res *", NULL },
	{ "nfsv4", "op-rename-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-rename-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-rename-start", 2, 1, "RENAME4args *", NULL },
	{ "nfsv4", "op-rename-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-rename-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-rename-done", 2, 1, "RENAME4res *", NULL },
	{ "nfsv4", "op-renew-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-renew-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-renew-start", 2, 1, "RENEW4args *", NULL },
	{ "nfsv4", "op-renew-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-renew-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-renew-done", 2, 1, "RENEW4res *", NULL },
	{ "nfsv4", "op-restorefh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-restorefh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-restorefh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-restorefh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-restorefh-done", 2, 1, "RESTOREFH4res *", NULL },
	{ "nfsv4", "op-savefh-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-savefh-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-savefh-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-savefh-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-savefh-done", 2, 1, "SAVEFH4res *", NULL },
	{ "nfsv4", "op-secinfo-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-secinfo-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-secinfo-start", 2, 1, "SECINFO4args *", NULL },
	{ "nfsv4", "op-secinfo-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-secinfo-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-secinfo-done", 2, 1, "SECINFO4res *", NULL },
	{ "nfsv4", "op-setattr-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-setattr-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setattr-start", 2, 1, "SETATTR4args *", NULL },
	{ "nfsv4", "op-setattr-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-setattr-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setattr-done", 2, 1, "SETATTR4res *", NULL },
	{ "nfsv4", "op-setclientid-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-setclientid-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setclientid-start", 2, 1, "SETCLIENTID4args *", NULL },
	{ "nfsv4", "op-setclientid-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-setclientid-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setclientid-done", 2, 1, "SETCLIENTID4res *", NULL },
	{ "nfsv4", "op-setclientid-confirm-start", 0, 0,
	  "struct compound_state *", "conninfo_t *" },
	{ "nfsv4", "op-setclientid-confirm-start", 1, 0,
	  "struct compound_state *", "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setclientid-confirm-start", 2, 1,
	  "SETCLIENTID_CONFIRM4args *", NULL },
	{ "nfsv4", "op-setclientid-confirm-done", 0, 0,
	  "struct compound_state *", "conninfo_t *" },
	{ "nfsv4", "op-setclientid-confirm-done", 1, 0,
	  "struct compound_state *", "nfsv4opinfo_t *" },
	{ "nfsv4", "op-setclientid-confirm-done", 2, 1,
	  "SETCLIENTID_CONFIRM4res *", NULL },
	{ "nfsv4", "op-verify-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-verify-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-verify-start", 2, 1, "VERIFY4args *", NULL },
	{ "nfsv4", "op-verify-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-verify-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-verify-done", 2, 1, "VERIFY4res *", NULL },
	{ "nfsv4", "op-write-start", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-write-start", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-write-start", 2, 1, "WRITE4args *", NULL },
	{ "nfsv4", "op-write-done", 0, 0, "struct compound_state *",
	  "conninfo_t *" },
	{ "nfsv4", "op-write-done", 1, 0, "struct compound_state *",
	  "nfsv4opinfo_t *" },
	{ "nfsv4", "op-write-done", 2, 1, "WRITE4res *", NULL },
	{ "nfsv4", "cb-recall-start", 0, 0, "rfs4_client_t *",
	  "conninfo_t *" },
	{ "nfsv4", "cb-recall-start", 1, 1, "rfs4_deleg_state_t *",
	  "nfsv4cbinfo_t *" },
	{ "nfsv4", "cb-recall-start", 2, 2, "CB_RECALL4args *", NULL },
	{ "nfsv4", "cb-recall-done", 0, 0, "rfs4_client_t *",
	  "conninfo_t *" },
	{ "nfsv4", "cb-recall-done", 1, 1, "rfs4_deleg_state_t *",
	  "nfsv4cbinfo_t *" },
	{ "nfsv4", "cb-recall-done", 2, 2, "CB_RECALL4res *", NULL },

	{ "ip", "send", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "ip", "send", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "ip", "send", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "ip", "send", 3, 3, "struct ifnet *", "ifinfo_t *" },
	{ "ip", "send", 4, 4, "struct ip *", "ipv4info_t *" },
	{ "ip", "send", 5, 5, "struct ip6_hdr *", "ipv6info_t *" },
	{ "ip", "receive", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "ip", "receive", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "ip", "receive", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "ip", "receive", 3, 3, "struct ifnet *", "ifinfo_t *" },
	{ "ip", "receive", 4, 4, "struct ip *", "ipv4info_t *" },
	{ "ip", "receive", 5, 5, "struct ip6_hdr *", "ipv6info_t *" },

	{ "tcp", "connect-established", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "connect-established", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "connect-established", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "connect-established", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "connect-established", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "connect-refused", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "connect-refused", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "connect-refused", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "connect-refused", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "connect-refused", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "connect-request", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "connect-request", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "connect-request", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "connect-request", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "connect-request", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "accept-established", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "accept-established", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "accept-established", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "accept-established", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "accept-established", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "accept-refused", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "accept-refused", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "accept-refused", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "accept-refused", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "accept-refused", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "state-change", 0, 0, "void", "void" },
	{ "tcp", "state-change", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "state-change", 2, 2, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "state-change", 3, 3, "int32_t", "tcpnsinfo_t *" },
	{ "tcp", "send", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "send", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "send", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "send", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "send", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "receive", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "tcp", "receive", 1, 1, "struct inpcb *", "csinfo_t *" },
	{ "tcp", "receive", 2, 2, "void_ip_t *", "ipinfo_t *" },
	{ "tcp", "receive", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "tcp", "receive", 4, 4, "struct tcphdr *", "tcpinfo_t *" },
	{ "tcp", "cc", 0, 0, "struct mbuf *", "pktinfo_t *"},
	{ "tcp", "cc", 1, 1, "struct inpcb *", "csinfo_t *"},
	{ "tcp", "cc", 2, 2, "struct tcpcb *", "tcpsinfo_t *"},
	{ "tcp", "cc", 3, 3, "struct tcphdr *", "tcpinfo_t *"},
	{ "tcp", "cc", 4, 4, "int32_t", "tcpccevent_t *"},
	{ "tcp", "iaj", 0, 0, "struct tcpcb *", "tcpsinfo_t *"},
	{ "tcp", "iaj", 1, 1, "uint32_t", NULL},
	{ "tcp", "iaj", 2, 2, "uint32_t", NULL},
	{ "sysevent", "post", 0, 0, "evch_bind_t *", "syseventchaninfo_t *" },
	{ "sysevent", "post", 1, 1, "sysevent_impl_t *", "syseventinfo_t *" },
	/* mptcp::input has no arguments */
	{ "mptcp", "receive-degraded", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "mptcp", "receive-degraded", 1, 1, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "receive-degraded", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "receive-degraded", 3, 3, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "receive-degraded", 4, 4, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "receive", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "mptcp", "receive", 1, 1, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "receive", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "receive", 3, 3, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "receive", 4, 4, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "receive", 5, 5, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "output", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "output", 1, 1, "struct mptsub *", "mptsubinfo_t *" },
	{ "mptcp", "output", 2, 2, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "state-change", 0, 0, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "state-change", 1, 1, "uint32_t", "uint32_t" },
	{ "mptcp", "checksum-result", 0, 0, "struct tcpcb *", "tcpsinfo_t *" },
	{ "mptcp", "checksum-result", 1, 1, "struct mbuf *", "pktinfo_t *" },
	{ "mptcp", "checksum-result", 2, 2, "uint32_t", "uint32_t" },
	{ "mptcp", "session-create", 0, 0, "struct mppcb *", "mppsinfo_t *" },
	{ "mptcp", "session-destroy", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "session-destroy", 1, 1, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "subflow-create", 0, 0, "struct mptses *", "mptsesinfo_t *"},
	{ "mptcp", "subflow-create", 1, 1, "struct mptsub *", "mptsubinfo_t *"},
	{ "mptcp", "subflow-create", 2, 2, "int", "int" },
	{ "mptcp", "subflow-create", 3, 3, "int", "int" },
	{ "mptcp", "subflow-close", 0, 0, "struct mptsub *", "mptsubinfo_t *" },
	{ "mptcp", "subflow-close", 1, 1, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "subflow-close", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "subflow-close", 3, 3, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "subflow-close", 4, 4, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "subflow-connect", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "subflow-connect", 1, 1, "struct mptsub *", "mptsubinfo_t *" },
	{ "mptcp", "subflow-connect", 2, 2, "int", "int" },
	{ "mptcp", "subflow-receive", 0, 0, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "subflow-receive", 1, 1, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "subflow-receive", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "subflow-input", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "subflow-input", 1, 1, "struct mptsub *", "mptsubinfo_t *" },
	{ "mptcp", "subflow-output", 0, 0, "struct mptses *", "mptsesinfo_t *"},
	{ "mptcp", "subflow-output", 1, 1, "struct mptsub *", "mptsubinfo_t *"},
	{ "mptcp", "subflow-events", 0, 0, "struct mptses *", "mptsesinfo_t *"},
	{ "mptcp", "subflow-events", 1, 1, "struct mptsub *", "mptsubinfo_t *"},
	{ "mptcp", "subflow-events", 2, 2, "uint32_t", "uint32_t"},
	{ "mptcp", "send", 0, 0, "struct mbuf *", "pktinfo_t *" },
	{ "mptcp", "send", 1, 1, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "send", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "send", 3, 3, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "send", 4, 4, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "send", 5, 5, "struct mptsub *", "mptsubinfo_t *" },
	{ "mptcp", "send", 6, 6, "size_t", "size_t" },
	{ "mptcp", "dispose", 0, 0, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "dispose", 1, 1, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "dispose", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "dispose", 3, 3, "struct mppcb *", "mppsinfo_t *" },
	{ "mptcp", "multipath-ready", 0, 0, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "multipath-ready", 1, 1, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "multipath-ready", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "multipath-ready", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "mptcp", "multipath-failed", 0, 0, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "multipath-failed", 1, 1, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "multipath-failed", 2, 2, "struct sockbuf *", "socketbuf_t *" },
	{ "mptcp", "multipath-failed", 3, 3, "struct tcpcb *", "tcpsinfo_t *" },
	{ "mptcp", "start-timer", 0, 0, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "start-timer", 1, 1, "int", "int" },
	{ "mptcp", "cancel-timer", 0, 0, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "cancel-timer", 1, 1, "int", "int" },
	{ "mptcp", "timer", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "timer", 1, 1, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "error", 0, 0, "struct mptcb *", "mptsinfo_t *" },
	{ "mptcp", "connectx", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "connectx", 1, 1, "sae_associd_t", "sae_associd_t" },
	{ "mptcp", "connectx", 2, 2, "struct socket *", "socketinfo_t *" },
	{ "mptcp", "disconnectx", 0, 0, "struct mptses *", "mptsesinfo_t *" },
	{ "mptcp", "disconnectx", 1, 1, "sae_associd_t", "sae_associd_t" },
	{ "mptcp", "disconnectx", 2, 2, "sae_connid_t", "sae_connid_t" },
	{ "mptcp", "disconnectx", 3, 3, "struct socket *", "sockinfo_t *" },
	{ "mptcp", "disconnectx", 4, 4, "struct mptcb *", "mptsinfo_t *" },
	{"vminfo", "vm_map_lookup_entry_failure", 0, 0, "vm_map_offset_t", "vm_map_offset_t"},
	{"vminfo", "vm_map_lookup_entry_failure", 1, 1, "vm_map_offset_t", "vm_map_offset_t"},
	{"vminfo", "kalloc", 0, 0, "vm_size_t", "vm_size_t" },
	{"vminfo", "kalloc", 1, 1, "vm_size_t", "vm_size_t" },
	{"vminfo", "kalloc", 2, 2, "void*", "void*" },
	{"vminfo", "kfree", 0, 0, "vm_size_t", "vm_size_t" },
	{"vminfo", "kfree", 1, 1, "vm_size_t", "vm_size_t" },
	{"vminfo", "kfree", 2, 2, "void*", "void*" },
	{"vminfo", "zalloc", 0, 0, "zone_t", "zone_t" },
	{"vminfo", "zalloc", 1, 1, "void*", "void*" },
	{"vminfo", "zfree", 0, 0, "zone_t", "zone_t" },
	{"vminfo", "zfree", 1, 1, "void*", "void*" },
	{"vminfo", "vm_sanitize", 0, 0, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 1, 1, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 2, 2, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 3, 3, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 4, 4, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 5, 5, "uint64_t", "uint64_t" },
	{"vminfo", "vm_sanitize", 6, 6, "uint64_t", "uint64_t" },
	{"vminfo", "corpse_footprint_collect", 0, 0, "uint32_t", "uint32_t" },
	{"vminfo", "corpse_footprint_collect", 1, 1, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect", 2, 2, "uint32_t", "uint32_t" },
	{"vminfo", "corpse_footprint_collect", 3, 3, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_new_region", 0, 0, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_new_region", 1, 1, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_new_region", 2, 2, "uint64_t", "uint64_t" },
	{"vminfo", "corpse_footprint_collect_zero_gap", 0, 0, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_zero_gap", 1, 1, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_zero_gap", 2, 2, "uint64_t", "uint64_t" },
	{"vminfo", "corpse_footprint_collect_page_info", 0, 0, "vm_map_offset_t", "vm_map_offset_t" },
	{"vminfo", "corpse_footprint_collect_page_info", 1, 1, "uint8_t", "uint8_t" },
	{"vminfo", "reclaim_ring_allocate", 0, 0, "mach_vm_address_t", "mach_vm_address_t" },
	{"vminfo", "reclaim_ring_allocate", 1, 1, "mach_vm_reclaim_count_t", "mach_vm_reclaim_count_t" },
	{"vminfo", "reclaim_ring_allocate", 2, 2, "mach_vm_reclaim_count_t", "mach_vm_reclaim_count_t" },
	{"vminfo", "reclaim_ring_resize", 0, 0, "mach_vm_reclaim_count_t", "mach_vm_reclaim_count_t" },
	{"vminfo", "reclaim_ring_resize", 1, 1, "mach_vm_reclaim_count_t", "mach_vm_reclaim_count_t" },
	{"vminfo", "reclaim_flush", 0, 0, "mach_vm_reclaim_count_t", "mach_vm_reclaim_count_t" },
	{"vminfo", "reclaim_flush", 1, 1, "size_t", "size_t" },
	{"vminfo", "reclaim_entry", 0, 0, "pid_t", "pid_t" },
	{"vminfo", "reclaim_entry", 1, 1, "mach_vm_address_t", "mach_vm_address_t" },
	{"vminfo", "reclaim_entry", 2, 2, "mach_vm_address_t", "mach_vm_address_t" },
	{"vminfo", "reclaim_entry", 3, 3, "mach_vm_reclaim_action_t", "mach_vm_recliam_action_t" },
	{"vminfo", "reclaim_sample", 0, 0, "pid_t", "pid_t" },
	{"vminfo", "reclaim_sample", 1, 1, "size_t", "size_t" },
	{"vminfo", "reclaim_sample", 2, 2, "size_t", "size_t" },
	{"vminfo", "reclaim_sample", 3, 3, "size_t", "size_t" },
	{"vminfo", "reclaim_sample", 4, 4, "size_t", "size_t" },
	{"vminfo", "reclaim_trim", 0, 0, "pid_t", "pid_t" },
	{"vminfo", "reclaim_trim", 1, 1, "size_t", "size_t" },
	{"vminfo", "reclaim_trim", 2, 2, "size_t", "size_t" },
	{"vminfo", "reclaim_sample", 0, 0, "pid_t", "pid_t" },
	{"vminfo", "reclaim_sample", 1, 1, "uint64_t", "uint64_t" },
	{"vminfo", "reclaim_sample", 2, 2, "size_t", "size_t" },
	{"vminfo", "reclaim_sample", 3, 3, "size_t", "size_t" },
	{"vminfo", "reclaim_drain", 0, 0, "pid_t", "pid_t" },
	{"vminfo", "reclaim_drain", 1, 1, "size_t", "size_t" },
#if CONFIG_KCOV && CONFIG_STKSZ
	{"kcov", "stksz-threshold-above", 0, 0, "uint32_t", "uint32_t" },
	{"kcov", "stksz-threshold-below", 0, 0, "uint32_t", "uint32_t" },
	{"kcov", "stksz-delta", 0, 0, "uint32_t", "uint32_t" },
#endif /* CONFIG_KCOV && CONFIG_STKSZ */
#if defined(__x86_64__) && HYPERVISOR
	{"hv", "task-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "task-trap-begin", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "task-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "task-trap-end", 1, 1, "uint32_t", "uint32_t" },
	{"hv", "thread-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "thread-trap-begin", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "thread-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "thread-trap-end", 1, 1, "uint32_t", "uint32_t" },
	{"hv", "enter-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "enter-begin", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "enter-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "enter-end", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "enter-end", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "enter-error", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "enter-error", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "enter-error", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "apic_access-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "apic_access-exit-begin", 2, 2, "uint64_t", "vmcs_eq_apic_access_t *" },
	{"hv", "apic_access-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "apic_access-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "apic_access-exit-end", 3, 3, "uint32_t", "uint32_t" },
	{"hv", "apic_write-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "apic_write-exit-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "apic_write-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "apic_write-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "ept_violation-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "ept_violation-exit-begin", 2, 2, "uint64_t", "vmcs_eq_ept_violation_t *" },
	{"hv", "ept_violation-exit-begin", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "ept_violation-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "ept_violation-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "ept_violation-exit-end", 3, 3, "uint8_t", "uint8_t" },
	{"hv", "exc_nmi-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "exc_nmi-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "exc_nmi-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "hlt-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "hlt-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "hlt-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "io-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "io-exit-begin", 2, 2, "uint64_t", "vmcs_eq_io_t *" },
	{"hv", "io-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "io-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "irq-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "irq-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "irq-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "irq_wnd-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "irq_wnd-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "irq_wnd-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "mov_dr-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "mov_dr-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "rdmsr-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "rdmsr-exit-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "rdmsr-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "rdmsr-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "rdmsr-exit-end", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "rdpmc-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "rdpmc-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "rdpmc-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "tpr_threshold-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "tpr_threshold-exit-begin", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "tpr_threshold-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "tpr_threshold-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "virtual_nmi_wnd-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "virtual_nmi_wnd-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vmx_timer_expired-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vmx_timer_expired-exit-begin", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vmx_timer_expired-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vmx_timer_expired-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "wrmsr-exit-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "wrmsr-exit-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "wrmsr-exit-begin", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "wrmsr-exit-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "wrmsr-exit-end", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "interrupt-inject", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "interrupt-inject", 2, 2, "uint32_t", "vmcs_irq_info_t *" },
	{"hv", "nmi-inject", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "nmi-inject", 2, 2, "uint32_t", "vmcs_irq_info_t *" },
	{"hv", "interrupt-receive", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "interrupt-send", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-hit", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-hit", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-hit", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "lsc-insert", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-insert", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-insert", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "lsc-insert-imm32", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-insert-imm32", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-insert-imm32", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "lsc-invalid", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-invalid", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-invalid", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "lsc-invalidate", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-invalidate", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-miss", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "lsc-miss", 2, 2, "uint8_t", "uint8_t" },
	{"hv", "lsc-miss", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "ipi-send", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "ipi-send", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "ipi-send", 3, 3, "uint8_t", "uint8_t" },
	{"hv", "nmi-send", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "nmi-send", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vm_addrspace_create-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_addrspace_destroy-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_addrspace_destroy-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_map-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_map-trap-begin", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "vm_map-trap-begin", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vm_map-trap-begin", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "vm_map-trap-begin", 4, 4, "uint64_t", "uint64_t" },
	{"hv", "vm_map-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_protect-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_protect-trap-begin", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "vm_protect-trap-begin", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vm_protect-trap-begin", 3, 3, "uint64_t", "uint64_t" },
	{"hv", "vm_protect-trap-begin", 4, 4, "uint64_t", "uint64_t" },
	{"hv", "vm_protect-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_unmap-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vm_unmap-trap-begin", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "vm_unmap-trap-begin", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vm_unmap-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "timer-cancel", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "timer-fire", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "timer-fire", 1, 1, "uint16_t", "uint16_t" },
	{"hv", "timer-schedule", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "timer-schedule", 1, 1, "uint64_t", "uint64_t" },
	{"hv", "vcpu_read_apic-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_apic-trap-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_apic-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_apic-trap-end", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_vmcs-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_vmcs-trap-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_vmcs-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_read_vmcs-trap-end", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vcpu_run-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_run-trap-begin", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "vcpu_run-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_run-trap-end", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "vcpu_run-trap-end", 2, 2, "int", "int" },
	{"hv", "vcpu_run_until-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_run_until-trap-begin", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "vcpu_run_until-trap-begin", 2, 2, "uint64_t", "uint64_t" },
	{"hv", "vcpu_run_until-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_run_until-trap-end", 1, 1, "uint64_t *", "guest_regs_t *" },
	{"hv", "vcpu_run_until-trap-end", 2, 2, "int", "int" },
	{"hv", "vcpu_write_apic-trap-begin", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_write_apic-trap-begin", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vcpu_write_apic-trap-begin", 3, 3, "uint32_t", "uint32_t" },
	{"hv", "vcpu_write_apic-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "vcpu_write_apic-trap-end", 2, 2, "uint32_t", "uint32_t" },
	{"hv", "vm_intr_msi-trap-begin", 0, 0, "uint32_t", "msi_addr_t *" },
	{"hv", "vm_intr_msi-trap-begin", 1, 1, "uint32_t", "msi_data_t *" },
	{"hv", "vm_intr_msi-trap-end", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "tsc__offset__set", 0, 0, "uint32_t", "uint32_t" },
	{"hv", "tsc__offset__set", 2, 2, "uint64_t", "uint64_t"},
	{"hv", "tsc__offset__set", 3, 3, "uint64_t", "uint64_t"},
#endif /* __x86_64__ && HYPERVISOR */

	{"sandbox", "allow", 0, 0, "uint64_t *", "uint64_t *"},
	{"sandbox", "deny", 0, 0, "uint64_t *", "uint64_t *"},
	{"sandbox", "generic", 0, 0, "uint64_t *", "uint64_t *" },

	{ NULL, NULL, 0, 0, NULL, NULL }
};

/*ARGSUSED*/
void
sdt_getargdesc(void *arg, dtrace_id_t id, void *parg, dtrace_argdesc_t *desc)
{
#pragma unused(arg, id)
	sdt_probe_t *sdp = parg;
	int i;

	desc->dtargd_native[0] = '\0';
	desc->dtargd_xlate[0] = '\0';

	for (i = 0; sdt_args[i].sda_provider != NULL; i++) {
		sdt_argdesc_t *a = &sdt_args[i];

		if (strncmp(sdp->sdp_provider->sdtp_name, a->sda_provider, strlen(a->sda_provider) + 1) != 0) {
			continue;
		}

		if (a->sda_name != NULL &&
		    strncmp(sdp->sdp_name, a->sda_name, strlen(a->sda_name) + 1) != 0) {
			continue;
		}

		if (desc->dtargd_ndx != a->sda_ndx) {
			continue;
		}

		if (a->sda_native != NULL) {
			(void) strlcpy(desc->dtargd_native, a->sda_native, DTRACE_ARGTYPELEN);
		}

		if (a->sda_xlate != NULL) {
			(void) strlcpy(desc->dtargd_xlate, a->sda_xlate, DTRACE_ARGTYPELEN);
		}

		desc->dtargd_mapping = a->sda_mapping;
		return;
	}

	desc->dtargd_ndx = DTRACE_ARGNONE;
}
