/*
 * Copyright (c) 2010 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#ifndef _SYS_CONTENT_PROTECTION_H_
#define _SYS_CONTENT_PROTECTION_H_

#ifdef PRIVATE

/*
 * Protection classes vary in their restrictions on read/writability.  A is generally
 * the strictest, and D is effectively no restriction.
 */

/*
 * dir_none forces new items created in the directory to pick up the mount point default
 * protection level. it is only allowed for directories.
 */
#define PROTECTION_CLASS_DIR_NONE 0

#define PROTECTION_CLASS_A  1
#define PROTECTION_CLASS_B  2
#define PROTECTION_CLASS_C  3
#define PROTECTION_CLASS_D  4
#define PROTECTION_CLASS_E  5
#define PROTECTION_CLASS_F  6
#define PROTECTION_CLASS_CX 7

#define PROTECTION_CLASS_MIN  PROTECTION_CLASS_A
#define PROTECTION_CLASS_MAX  PROTECTION_CLASS_CX

/*
 * This forces open_dprotected_np to behave as though the file were created with
 * the traditional open(2) semantics.
 */
#define PROTECTION_CLASS_DEFAULT  (-1)

#endif /* PRIVATE */

#endif /* _SYS_CONTENT_PROTECTION_H_ */
