/*
 * Copyright (c) 2020 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef log_internal_h
#define log_internal_h

#include <os/log_private.h>

typedef struct {
	firehose_tracepoint_id_u    lp_ftid;
	uint64_t                    lp_timestamp;
	uint16_t                    lp_pub_data_size;
	uint16_t                    lp_data_size;
	firehose_stream_t           lp_stream;
} log_payload_s, *log_payload_t;

bool log_payload_send(log_payload_t, const void *, bool);
bool os_log_subsystem_id_valid(uint16_t);

#endif /* log_internal */
