/*
 * Copyright (c) 2019 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
#ifndef _INSTRUCTIONS_H_
#define _INSTRUCTIONS_H_

#define ARM64_INSTR_LDST_MASK         (0x0a000000)
#define ARM64_INSTR_LDST_BITS         (0x08000000)
#define ARM64_INSTR_IS_LDST(x)        (((x) & ARM64_INSTR_LDST_MASK) == ARM64_INSTR_LDST_BITS)

#define ARM64_INSTR_LDST_RN_MASK      0x1f
#define ARM64_INSTR_LDST_RN_SHIFT     5
#define ARM64_INSTR_LDST_RN_GET(x)    (((x) >> ARM64_INSTR_LDST_RN_SHIFT) & ARM64_INSTR_LDST_RN_MASK)



#define ARM64_INSTR_CAS_MASK          (0x3fa07c00)
#define ARM64_INSTR_CAS_BITS          (0x08a07c00)
#define ARM64_INSTR_IS_CAS(x)         (((x) & ARM64_INSTR_CAS_MASK) == ARM64_INSTR_CAS_BITS)

#define ARM64_INSTR_CAS_SZ_MASK   0x3
#define ARM64_INSTR_CAS_SZ_SHIFT  30
#define ARM64_INSTR_CAS_SZ_GET(x) (((x) >> ARM64_INSTR_CAS_SZ_SHIFT) & ARM64_INSTR_CAS_SZ_MASK)

#define ARM64_INSTR_CAS_A_MASK    0x1
#define ARM64_INSTR_CAS_A_SHIFT   22
#define ARM64_INSTR_CAS_A_GET(x)  (((x) >> ARM64_INSTR_CAS_A_SHIFT) & ARM64_INSTR_CAS_A_MASK)

#define ARM64_INSTR_CAS_RS_MASK   0x1f
#define ARM64_INSTR_CAS_RS_SHIFT  16
#define ARM64_INSTR_CAS_RS_GET(x) (((x) >> ARM64_INSTR_CAS_RS_SHIFT) & ARM64_INSTR_CAS_RS_MASK)

#define ARM64_INSTR_CAS_R_MASK    0x1
#define ARM64_INSTR_CAS_R_SHIFT   15
#define ARM64_INSTR_CAS_R_GET(x)  (((x) >> ARM64_INSTR_CAS_R_SHIFT) & ARM64_INSTR_CAS_R_MASK)

#define ARM64_INSTR_CAS_RN_GET(x) ARM64_INSTR_LDST_RN_GET(x)

#define ARM64_INSTR_CAS_RT_MASK   0x1f
#define ARM64_INSTR_CAS_RT_SHIFT  0
#define ARM64_INSTR_CAS_RT_GET(x) (((x) >> ARM64_INSTR_CAS_RT_SHIFT) & ARM64_INSTR_CAS_RT_MASK)



#define ARM64_INSTR_CASP_MASK         (0xbfa07c00)
#define ARM64_INSTR_CASP_BITS         (0x08207c00)
#define ARM64_INSTR_IS_CASP(x)        (((x) & ARM64_INSTR_CASP_MASK) == ARM64_INSTR_CASP_BITS)

#define ARM64_INSTR_CASP_SZ_MASK   0x1
#define ARM64_INSTR_CASP_SZ_SHIFT  30
#define ARM64_INSTR_CASP_SZ_GET(x) (((x) >> ARM64_INSTR_CASP_SZ_SHIFT) & ARM64_INSTR_CASP_SZ_MASK)

#define ARM64_INSTR_CASP_A_MASK    0x1
#define ARM64_INSTR_CASP_A_SHIFT   22
#define ARM64_INSTR_CASP_A_GET(x)  (((x) >> ARM64_INSTR_CASP_A_SHIFT) & ARM64_INSTR_CASP_A_MASK)

#define ARM64_INSTR_CASP_RS_MASK   0x1f
#define ARM64_INSTR_CASP_RS_SHIFT  16
#define ARM64_INSTR_CASP_RS_GET(x) (((x) >> ARM64_INSTR_CASP_RS_SHIFT) & ARM64_INSTR_CASP_RS_MASK)

#define ARM64_INSTR_CASP_R_MASK    0x1
#define ARM64_INSTR_CASP_R_SHIFT   15
#define ARM64_INSTR_CASP_R_GET(x)  (((x) >> ARM64_INSTR_CASP_R_SHIFT) & ARM64_INSTR_CASP_R_MASK)

#define ARM64_INSTR_CASP_RN_GET(x) ARM64_INSTR_LDST_RN_GET(x)

#define ARM64_INSTR_CASP_RT_MASK   0x1f
#define ARM64_INSTR_CASP_RT_SHIFT  0
#define ARM64_INSTR_CASP_RT_GET(x) (((x) >> ARM64_INSTR_CASP_RT_SHIFT) & ARM64_INSTR_CASP_RT_MASK)



#define ARM64_INSTR_ATOMIC_LDST_MASK  (0x3f208c00)
#define ARM64_INSTR_ATOMIC_LDST_BITS  (0x38200000)
#define ARM64_INSTR_IS_ATOMIC_LDST(x) (((x) & ARM64_INSTR_ATOMIC_LDST_MASK) == ARM64_INSTR_ATOMIC_LDST_BITS)

#define ARM64_INSTR_ATOMIC_LDST_SZ_MASK   0x3
#define ARM64_INSTR_ATOMIC_LDST_SZ_SHIFT  30
#define ARM64_INSTR_ATOMIC_LDST_SZ_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_SZ_SHIFT) & ARM64_INSTR_ATOMIC_LDST_SZ_MASK)

#define ARM64_INSTR_ATOMIC_LDST_A_MASK    0x1
#define ARM64_INSTR_ATOMIC_LDST_A_SHIFT   23
#define ARM64_INSTR_ATOMIC_LDST_A_GET(x)  (((x) >> ARM64_INSTR_ATOMIC_LDST_A_SHIFT) & ARM64_INSTR_ATOMIC_LDST_A_MASK)

#define ARM64_INSTR_ATOMIC_LDST_R_MASK    0x1
#define ARM64_INSTR_ATOMIC_LDST_R_SHIFT   22
#define ARM64_INSTR_ATOMIC_LDST_R_GET(x)  (((x) >> ARM64_INSTR_ATOMIC_LDST_R_SHIFT) & ARM64_INSTR_ATOMIC_LDST_R_MASK)

#define ARM64_INSTR_ATOMIC_LDST_RS_MASK   0x1f
#define ARM64_INSTR_ATOMIC_LDST_RS_SHIFT  16
#define ARM64_INSTR_ATOMIC_LDST_RS_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_RS_SHIFT) & ARM64_INSTR_ATOMIC_LDST_RS_MASK)

#define ARM64_INSTR_ATOMIC_LDST_OPC_ADD    0
#define ARM64_INSTR_ATOMIC_LDST_OPC_BIC    1
#define ARM64_INSTR_ATOMIC_LDST_OPC_EOR    2
#define ARM64_INSTR_ATOMIC_LDST_OPC_ORR    3
#define ARM64_INSTR_ATOMIC_LDST_OPC_SMAX   4
#define ARM64_INSTR_ATOMIC_LDST_OPC_SMIN   5
#define ARM64_INSTR_ATOMIC_LDST_OPC_UMAX   6
#define ARM64_INSTR_ATOMIC_LDST_OPC_UMIN   7

#define ARM64_INSTR_ATOMIC_LDST_OPC_MASK   0x7
#define ARM64_INSTR_ATOMIC_LDST_OPC_SHIFT  12
#define ARM64_INSTR_ATOMIC_LDST_OPC_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_OPC_SHIFT) & ARM64_INSTR_ATOMIC_LDST_OPC_MASK)

#define ARM64_INSTR_ATOMIC_LDST_RN_GET(x) ARM64_INSTR_LDST_RN_GET(x)

#define ARM64_INSTR_ATOMIC_LDST_RT_MASK   0x1f
#define ARM64_INSTR_ATOMIC_LDST_RT_SHIFT  0
#define ARM64_INSTR_ATOMIC_LDST_RT_GET(x) (((x) >> ARM64_INSTR_ATOMIC_LDST_RT_SHIFT) & ARM64_INSTR_ATOMIC_LDST_RT_MASK)



#define ARM64_INSTR_SWP_MASK          (0x3f208c00)
#define ARM64_INSTR_SWP_BITS          (0x38208000)
#define ARM64_INSTR_IS_SWP(x)         (((x) & ARM64_INSTR_SWP_MASK) == ARM64_INSTR_SWP_BITS)

#define ARM64_INSTR_SWP_SZ_MASK   0x3
#define ARM64_INSTR_SWP_SZ_SHIFT  30
#define ARM64_INSTR_SWP_SZ_GET(x) (((x) >> ARM64_INSTR_SWP_SZ_SHIFT) & ARM64_INSTR_SWP_SZ_MASK)

#define ARM64_INSTR_SWP_A_MASK    0x1
#define ARM64_INSTR_SWP_A_SHIFT   23
#define ARM64_INSTR_SWP_A_GET(x)  (((x) >> ARM64_INSTR_SWP_A_SHIFT) & ARM64_INSTR_SWP_A_MASK)

#define ARM64_INSTR_SWP_R_MASK    0x1
#define ARM64_INSTR_SWP_R_SHIFT   22
#define ARM64_INSTR_SWP_R_GET(x)  (((x) >> ARM64_INSTR_SWP_R_SHIFT) & ARM64_INSTR_SWP_R_MASK)

#define ARM64_INSTR_SWP_RS_MASK   0x1f
#define ARM64_INSTR_SWP_RS_SHIFT  16
#define ARM64_INSTR_SWP_RS_GET(x) (((x) >> ARM64_INSTR_SWP_RS_SHIFT) & ARM64_INSTR_SWP_RS_MASK)

#define ARM64_INSTR_SWP_OPC_MASK   0x7
#define ARM64_INSTR_SWP_OPC_SHIFT  12
#define ARM64_INSTR_SWP_OPC_GET(x) (((x) >> ARM64_INSTR_SWP_OPC_SHIFT) & ARM64_INSTR_SWP_OPC_MASK)

#define ARM64_INSTR_SWP_RN_GET(x) ARM64_INSTR_LDST_RN_GET(x)

#define ARM64_INSTR_SWP_RT_MASK   0x1f
#define ARM64_INSTR_SWP_RT_SHIFT  0
#define ARM64_INSTR_SWP_RT_GET(x) (((x) >> ARM64_INSTR_SWP_RT_SHIFT) & ARM64_INSTR_SWP_RT_MASK)



#define ARM64_INSTR_LDST_REG_OFFSET_MASK                (0x3b200c00)
#define ARM64_INSTR_LDST_REG_OFFSET_BITS                (0x38200800)
#define ARM64_INSTR_IS_LDST_REG_OFFSET(x)               (((x) & ARM64_INSTR_LDST_REG_OFFSET_MASK) == ARM64_INSTR_LDST_REG_OFFSET_BITS)

#define ARM64_INSTR_LDST_REG_OFFSET_RM_MASK             0x1f
#define ARM64_INSTR_LDST_REG_OFFSET_RM_SHIFT            16
#define ARM64_INSTR_LDST_REG_OFFSET_RM_GET(x)           (((x) >> ARM64_INSTR_LDST_REG_OFFSET_RM_MASK) & ARM64_INSTR_LDST_REG_OFFSET_RM_SHIFT)

enum arm64_ldst_reg_extend_type {
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_UXTB = 0b000,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_UXTH = 0b001,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_UXTW = 0b010,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_UXTX = 0b011,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_STXB = 0b100,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_STXH = 0b101,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_SXTW = 0b110,
	ARM64_INSTR_LDST_REG_OFFSET_OPTION_SXTX = 0b111,
};
#define ARM64_INSTR_LDST_REG_OFFSET_OPTION_MASK         0b111
#define ARM64_INSTR_LDST_REG_OFFSET_OPTION_SHIFT        13
#define ARM64_INSTR_LDST_REG_OFFSET_OPTION_GET(x)       (((x) >> ARM64_INSTR_LDST_REG_OFFSET_OPTION_SHIFT) & ARM64_INSTR_LDST_REG_OFFSET_OPTION_MASK)

#define ARM64_INSTR_LDST_REG_OFFSET_S_MASK              0b1
#define ARM64_INSTR_LDST_REG_OFFSET_S_SHIFT             12
#define ARM64_INSTR_LDST_REG_OFFSET_S_GET(x)            (((x) >> ARM64_INSTR_LDST_REG_OFFSET_S_MASK) & ARM64_INSTR_LDST_REG_OFFSET_S_SHIFT)



#define ARM64_INSTR_AUTxx_MASK          (0xffffd000)
#define ARM64_INSTR_AUTxx_BITS          (0xdac11000)
#define ARM64_INSTR_IS_AUTxx(x)         (((x) & ARM64_INSTR_AUTxx_MASK) == ARM64_INSTR_AUTxx_BITS)

#define ARM64_INSTR_AUTxx_RD_MASK       0x1f
#define ARM64_INSTR_AUTxx_RD_SHIFT      0
#define ARM64_INSTR_AUTxx_RD_GET(x)     (((x) >> ARM64_INSTR_AUTxx_RD_SHIFT) & ARM64_INSTR_AUTxx_RD_MASK)



#define ARM64_INSTR_AUTIx_SYSTEM_MASK                   (0xfffffd9f)
#define ARM64_INSTR_AUTIx_SYSTEM_BITS                   (0xd503219f)
#define ARM64_INSTR_IS_AUTIx_SYSTEM(x)                  (((x) & ARM64_INSTR_AUTIx_SYSTEM_MASK) == ARM64_INSTR_AUTIx_SYSTEM_BITS)

#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_MASK           0x7c
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_SHIFT          0x5
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_GET(x)         (((x) >> ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_SHIFT) & ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_MASK)
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_AUTIA1716      0xc
#define ARM64_INSTR_AUTIx_SYSTEM_CRM_OP2_AUTIB1716      0xe

#define ARM64_INSTR_LDRAx_MASK          (0xff200400)
#define ARM64_INSTR_LDRAx_BITS          (0xf8200400)
#define ARM64_INSTR_IS_LDRAx(x)         (((x) & ARM64_INSTR_LDRAx_MASK) == ARM64_INSTR_LDRAx_BITS)

#define ARM64_INSTR_BxRAx_MASK          (0xfedff800)
#define ARM64_INSTR_BxRAx_BITS          (0xd61f0800)
#define ARM64_INSTR_IS_BxRAx(x)         (((x) & ARM64_INSTR_BxRAx_MASK) == ARM64_INSTR_BxRAx_BITS)

#define ARM64_INSTR_BxRAx_RN_MASK       0x1f
#define ARM64_INSTR_BxRAx_RN_SHIFT      5
#define ARM64_INSTR_BxRAx_RN_GET(x)     (((x) >> ARM64_INSTR_BxRAx_RN_SHIFT) & ARM64_INSTR_BxRAx_RN_MASK)

#define ARM64_INSTR_RETAx_MASK          (0xfffffbff)
#define ARM64_INSTR_RETAx_BITS          (0xd65f0bff)
#define ARM64_INSTR_IS_RETAx(x)         (((x) & ARM64_INSTR_RETAx_MASK) == ARM64_INSTR_RETAx_BITS)

#if HAS_ARM_FEAT_SME
#define ARM64_INSTR_RDSVL_MASK                          (0xfffff800)
#define ARM64_INSTR_RDSVL_BITS                          (0x04bf5800)
#define ARM64_INSTR_IS_RDSVL(x)                         (((x) & ARM64_INSTR_RDSVL_MASK) == ARM64_INSTR_RDSVL_BITS)

#define ARM64_INSTR_RDSVL_IMM6_MASK                     0x3f
#define ARM64_INSTR_RDSVL_IMM6_SHIFT                    5
static inline int8_t
ARM64_INSTR_RDSVL_IMM6_GET(unsigned int opcode)
{
	uint8_t imm6_unsigned = (opcode >> ARM64_INSTR_RDSVL_IMM6_SHIFT) & ARM64_INSTR_RDSVL_IMM6_MASK;
	if (imm6_unsigned & (1 << 5)) {
		return (int8_t)(0b11000000 | imm6_unsigned);
	} else {
		return (int8_t)imm6_unsigned;
	}
}
#define ARM64_INSTR_RDSVL_RD_MASK                       0x1f
#define ARM64_INSTR_RDSVL_RD_SHIFT                      0
#define ARM64_INSTR_RDSVL_RD_GET(x)                     (((x) >> ARM64_INSTR_RDSVL_RD_SHIFT) & ARM64_INSTR_RDSVL_RD_MASK)
#endif /* HAS_ARM_FEAT_SME */

#endif /* _INSTRUCTIONS_H_ */
