/*
 * Copyright (c) 2024 Apple, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#include <vm/vm_memtag.h>

#if defined(ENABLE_MEMTAG_MANIPULATION_API)
#include <vm/vm_map_xnu.h>
#include <vm/pmap.h>

/* Do the right canonicalization based on the vm_map the address belongs to */
vm_map_address_t
vm_memtag_canonicalize(vm_map_t map, vm_map_address_t addr)
{
	assert(map);

	/* With no pmap assigned we cannot make a decision. Leave the address as is */
	if (map->pmap == NULL) {
		return addr;
	}

	/* NULL is a frequent enough special case. */
	if (addr == (vm_map_address_t)NULL) {
		return addr;
	}

	return (map->pmap == kernel_pmap) ?
	       (vm_map_address_t)vm_memtag_canonicalize_kernel(addr) :
	       (vm_map_address_t)vm_memtag_canonicalize_user(addr);
}
#endif /* ENABLE_MEMTAG_MANIPULATION_API */
