/*
 * Copyright (c) 2007-2009 Apple Inc. All rights reserved.
 * Copyright (c) 2000-2006 Apple Computer, Inc. All rights reserved.
 */
/*
 * @OSF_COPYRIGHT@
 */

#ifndef _PEXPERT_ARM64_BOOT_H_
#define _PEXPERT_ARM64_BOOT_H_

#ifdef KERNEL
#include <kern/kern_types.h>
#endif
#include <pexpert/arm/consistent_debug.h>
#include <pexpert/arm/protos.h>

#if !TARGET_OS_SIMULATOR
/*
 * Maximum size of an environment variable value. This particular value is
 * chosen to accommodate the maximum encoded size of the system token as
 * computed in https://confluence.sd.apple.com/display/TK/System+Token.
 *
 * This value matches iBoot's IBOOT_MAX_ENV_VAR_DATA_SIZE.
 */
#include <iBoot/boot_args_abi.h>
#define BOOT_LINE_LENGTH (IBOOT_MAX_ENV_VAR_DATA_SIZE)
#else /* TARGET_OS_SIMULATOR */
/**
 * Since iBoot does not import IBOOT_MAX_ENV_VAR_DATA_SIZE for simulators,
 * hardcode it here.
 */
#define BOOT_LINE_LENGTH 1024
#endif /* !TARGET_OS_SIMULATOR */

/*
 * Video information..
 */

struct Boot_Video {
	unsigned long   v_baseAddr;     /* Base address of video memory */
	unsigned long   v_display;      /* Display Code (if Applicable */
	unsigned long   v_rowBytes;     /* Number of bytes per pixel row */
	unsigned long   v_width;        /* Width */
	unsigned long   v_height;       /* Height */
	unsigned long   v_depth;        /* Pixel Depth and other parameters */
};

#define kBootVideoDepthMask             (0xFF)
#define kBootVideoDepthDepthShift       (0)
#define kBootVideoDepthRotateShift      (8)
#define kBootVideoDepthScaleShift       (16)
#define kBootVideoDepthBootRotateShift  (24)

#define kBootFlagsDarkBoot              (1ULL << 0)

typedef struct Boot_Video       Boot_Video;

/* Boot argument structure - passed into Mach kernel at boot time.
 */
#define kBootArgsRevision               1
#define kBootArgsRevision2              2       /* added boot_args.bootFlags */
#define kBootArgsVersion1               1
#define kBootArgsVersion2               2

typedef struct boot_args {
	uint16_t                Revision;                       /* Revision of boot_args structure */
	uint16_t                Version;                        /* Version of boot_args structure */
	uint64_t                virtBase;                       /* Virtual base of memory */
	uint64_t                physBase;                       /* Physical base of memory */
	uint64_t                memSize;                        /* Size of memory */
	uint64_t                topOfKernelData;        /* Highest physical address used in kernel data area */
	Boot_Video              Video;                          /* Video Information */
	uint32_t                machineType;            /* Machine Type */
	void                    *deviceTreeP;           /* Base of flattened device tree */
	uint32_t                deviceTreeLength;       /* Length of flattened tree */
	char                    CommandLine[BOOT_LINE_LENGTH];  /* Passed in command line */
	uint64_t                bootFlags;              /* Additional flags specified by the bootloader */
	uint64_t                memSizeActual;          /* Actual size of memory */
} boot_args;

#define SOC_DEVICE_TYPE_BUFFER_SIZE     32

#define PC_TRACE_BUF_SIZE               1024

#define CDBG_MEM ((sizeof(dbg_registry_t) + PAGE_SIZE - 1) & ~PAGE_MASK)

#define PE_EARLY_BOOT_VA (CDBG_MEM)

#endif /* _PEXPERT_ARM64_BOOT_H_ */
