#!/bin/bash

# Ensure all denylisted files exist. Paths with wildcards are ignored.
# Run against a denylist with fully-qualified paths.

IFS=$'\n'

denylist_files=`sed -n -e '
	# ignore paths with wildcards
	/\*/ d

	# strip leading 'src:'
	/^src/ {
		s/^src://
		p
	}
' $1`

ret=0

for f in $denylist_files ; do
	if ! [[ -e $f ]] ; then
		echo "KASan: denylisted file $f not found" >&2
		ret=1
	fi
done

exit $ret
