/*
 * Copyright (c) 2020-2024 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#ifndef ioc_str_h
#define ioc_str_h

#include <sys/socket.h>
#include <sys/kern_event.h>
#include <sys/sockio.h>
#include <sys/sockio_private.h>

#include <net/if.h>
#include <net/if_ppp.h>

#include <netinet/in.h>

#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>

#define SIOC_LIST \
	X(SIOCSIFADDR_IN6) \
	X(SIOCSIFADDR) \
	X(SIOCSIFDSTADDR_IN6) \
	X(SIOCSIFDSTADDR) \
	X(SIOCSIFFLAGS) \
	X(SIOCGIFFLAGS) \
	X(SIOCSIFBRDADDR) \
	X(SIOCSIFNETMASK_IN6) \
	X(SIOCSIFNETMASK) \
	X(SIOCGIFMETRIC) \
	X(SIOCSIFMETRIC) \
	X(SIOCDIFADDR_IN6) \
	X(SIOCDIFADDR) \
	X(SIOCAIFADDR_IN6) \
	X(SIOCAIFADDR) \
	X(SIOCGIFADDR_IN6) \
	X(SIOCGIFADDR) \
	X(SIOCGIFDSTADDR_IN6) \
	X(SIOCGIFDSTADDR) \
	X(SIOCGIFBRDADDR) \
	X(SIOCGIFCONF) \
	X(SIOCGIFNETMASK_IN6) \
	X(SIOCGIFNETMASK) \
	X(SIOCAUTOADDR) \
	X(SIOCAUTONETMASK) \
	X(SIOCARPIPLL) \
	X(SIOCADDMULTI) \
	X(SIOCDELMULTI) \
	X(SIOCGIFMTU) \
	X(SIOCSIFMTU) \
	X(SIOCGIFPHYS) \
	X(SIOCSIFPHYS) \
	X(SIOCSIFMEDIA) \
	X(SIOCGIFMEDIA) \
	X(SIOCSIFGENERIC) \
	X(SIOCGIFGENERIC) \
	X(SIOCRSLVMULTI) \
	X(SIOCSIFLLADDR) \
	X(SIOCGIFSTATUS) \
	X(SIOCSIFPHYADDR_IN6) \
	X(SIOCSIFPHYADDR) \
	X(SIOCGIFPSRCADDR_IN6) \
	X(SIOCGIFPSRCADDR) \
	X(SIOCGIFPDSTADDR_IN6) \
	X(SIOCGIFPDSTADDR) \
	X(SIOCDIFPHYADDR) \
	X(SIOCGIFDEVMTU) \
	X(SIOCSIFALTMTU) \
	X(SIOCSIFBOND) \
	X(SIOCGIFBOND) \
	X(SIOCGIFALTMTU) \
	X(SIOCGIFXMEDIA) \
	X(SIOCGIFAFLAG_IN6) \
	X(SIOCGIFINFO_IN6) \
	X(SIOCSNDFLUSH_IN6) \
	X(SIOCGNBRINFO_IN6) \
	X(SIOCSPFXFLUSH_IN6) \
	X(SIOCSRTRFLUSH_IN6) \
	X(SIOCPROTOATTACH) \
	X(SIOCGIFALIFETIME_IN6) \
	X(SIOCPROTODETACH) \
	X(SIOCSIFALIFETIME_IN6) \
	X(SIOCGIFSTAT_IN6) \
	X(SIOCGIFSTAT_ICMP6) \
	X(SIOCSDEFIFACE_IN6) \
	X(SIOCGDEFIFACE_IN6) \
	X(SIOCSIFINFO_FLAGS) \
	X(SIOCSSCOPE6) \
	X(SIOCGSCOPE6) \
	X(SIOCGSCOPE6DEF) \
	X(SIOCSIFCAP) \
	X(SIOCGIFCAP) \
	X(SIOCSIFMANAGEMENT) \
	X(SIOCGLINKHEURISTICS) \
	X(SIOCSATTACHPROTONULL) \
	X(SIOCGPOINTOPOINTMDNS) \
	X(SIOCSPOINTOPOINTMDNS) \
	X(SIOCSIFPREFIX_IN6) \
	X(SIOCGIFPREFIX_IN6) \
	X(SIOCDIFPREFIX_IN6) \
	X(SIOCAIFPREFIX_IN6) \
	X(SIOCCIFPREFIX_IN6) \
	X(SIOCSGIFPREFIX_IN6) \
	X(OSIOCGIFINFO_IN6) \
	X(SIOCPROTOATTACH_IN6) \
	X(SIOCPROTODETACH_IN6) \
	X(SIOCIFCREATE) \
	X(SIOCIFDESTROY) \
	X(SIOCGPPPCSTATS) \
	X(SIOCIFCREATE2) \
	X(SIOCGPPPSTATS) \
	X(SIOCGDRVSPEC) \
	X(SIOCSDRVSPEC) \
	X(SIOCGIFASYNCMAP) \
	X(SIOCSIFASYNCMAP) \
	X(SIOCSIFVLAN) \
	X(SIOCGIFVLAN) \
	X(SIOCIFGCLONERS) \
	X(SIOCLL_START) \
	X(SIOCGIFMAC) \
	X(SIOCLL_STOP) \
	X(SIOCSIFMAC) \
	X(SIOCAUTOCONF_START) \
	X(SIOCAUTOCONF_STOP) \
	X(SIOCSIFKPI) \
	X(SIOCGIFKPI) \
	X(SIOCSETROUTERMODE_IN6) \
	X(SIOCGIFWAKEFLAGS) \
	X(SIOCGETROUTERMODE_IN6) \
	X(SIOCGIFGETRTREFCNT) \
	X(SIOCGIFLINKQUALITYMETRIC) \
	X(SIOCSIFOPPORTUNISTIC) \
	X(SIOCGIFOPPORTUNISTIC) \
	X(SIOCSETROUTERMODE) \
	X(SIOCGIFEFLAGS) \
	X(SIOCSIFDESC) \
	X(SIOCGIFDESC) \
	X(SIOCSIFLINKPARAMS) \
	X(SIOCGIFLINKPARAMS) \
	X(SIOCGIFQUEUESTATS) \
	X(SIOCSIFTHROTTLE) \
	X(SIOCGIFTHROTTLE) \
	X(SIOCSIFLOG) \
	X(SIOCGIFLOG) \
	X(SIOCGIFDELEGATE) \
	X(SIOCGIFLLADDR) \
	X(SIOCGIFTYPE) \
	X(SIOCLL_CGASTART) \
	X(SIOCGIFEXPENSIVE) \
	X(SIOCSIFEXPENSIVE) \
	X(SIOCGIF2KCL) \
	X(SIOCSIF2KCL) \
	X(SIOCGSTARTDELAY) \
	X(SIOCAIFAGENTID) \
	X(SIOCDIFAGENTID) \
	X(SIOCGIFAGENTIDS) \
	X(SIOCGIFAGENTDATA) \
	X(SIOCSIFINTERFACESTATE) \
	X(SIOCGIFINTERFACESTATE) \
	X(SIOCSIFPROBECONNECTIVITY) \
	X(SIOCGIFPROBECONNECTIVITY) \
	X(SIOCGIFFUNCTIONALTYPE) \
	X(SIOCSIFNETSIGNATURE) \
	X(SIOCGIFNETSIGNATURE) \
	X(SIOCSECNMODE) \
	X(SIOCSIFORDER) \
	X(SIOCGIFORDER) \
	X(SIOCSQOSMARKINGMODE) \
	X(SIOCSQOSMARKINGENABLED) \
	X(SIOCGQOSMARKINGMODE) \
	X(SIOCGQOSMARKINGENABLED) \
	X(SIOCSIFTIMESTAMPENABLE) \
	X(SIOCSIFTIMESTAMPDISABLE) \
	X(SIOCGIFTIMESTAMPENABLED) \
	X(SIOCGIFCGAPREP_IN6) \
	X(SIOCSIFDISABLEOUTPUT) \
	X(SIOCSIFCGAPREP_IN6) \
	X(SIOCSIFSUBFAMILY) \
	X(SIOCCLAT46_START) \
	X(SIOCCLAT46_STOP) \
	X(SIOCGIFAGENTLIST) \
	X(SIOCSIFLOWINTERNET) \
	X(SIOCGIFLOWINTERNET) \
	X(SIOCGIFNAT64PREFIX) \
	X(SIOCSIFNAT64PREFIX) \
	X(SIOCGIFNEXUS) \
	X(SIOCSIF6LOWPAN) \
	X(SIOCGIFPROTOLIST) \
	X(SIOCGIF6LOWPAN) \
	X(SIOCGIFTCPKAOMAX) \
	X(SIOCGIFLOWPOWER) \
	X(SIOCSIFLOWPOWER) \
	X(SIOCGIFCLAT46ADDR) \
	X(SIOCGIFMPKLOG) \
	X(SIOCSIFMPKLOG) \
	X(SIOCGIFCONSTRAINED) \
	X(SIOCSIFCONSTRAINED) \
	X(SIOCGIFXFLAGS) \
	X(SIOCGIFNOACKPRIO) \
	X(SIOCSIFNOACKPRIO) \
	X(SIOCGETROUTERMODE) \
	X(SIOCSIFNETWORKID) \
	X(SIOCSIFMARKWAKEPKT) \
	X(SIOCSIFESTTHROUGHPUT) \
	X(SIOCSIFRADIODETAILS) \
	X(SIOCSIFLINKQUALITYMETRIC) \
	X(SIOCSIFNOTRAFFICSHAPING) \
	X(SIOCGIFNOTRAFFICSHAPING) \
	X(SIOCGIFGENERATIONID) \
	X(SIOCGIFULTRACONSTRAINED) \
	X(SIOCSIFULTRACONSTRAINED) \
	X(SIOCSIFPEEREGRESSFUNCTIONALTYPE) \
	X(SIOCSIFDIRECTLINK) \
	X(SIOCGIFDIRECTLINK) \
	X(SIOCSIFISVPN) \
	X(SIOCGIFDELAYWAKEPKTEVENT) \
	X(SIOCSIFDELAYWAKEPKTEVENT) \
	X(SIOCGIFDISABLEINPUT) \
	X(SIOCSIFDISABLEINPUT) \
	X(SIOCGIFCONGESTEDLINK) \
	X(SIOCSIFCONGESTEDLINK) \
	X(SIOCGIFL4S) \
	X(SIOCSIFL4S) \
	X(SIOCGINBANDWAKEPKT) \
	X(SIOCSINBANDWAKEPKT)

#endif /* ioc_str_h */
