/*
 * Copyright (c) 2009 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#ifndef VM_PRESSURE_H
#define VM_PRESSURE_H

#include <sys/queue.h>
#include <sys/event.h>

void vm_pressure_init(lck_grp_t *grp, lck_attr_t *attr);

int vm_knote_register(struct knote *);
void vm_knote_unregister(struct knote *);

void consider_vm_pressure_events(void);
void vm_pressure_proc_cleanup(proc_t);

#if VM_PRESSURE_EVENTS
void vm_find_pressure_foreground_candidates(void);
void vm_find_pressure_candidate(void);
boolean_t vm_dispatch_pressure_note_to_pid(pid_t pid, boolean_t locked);
#endif /* VM_PRESSURE_EVENTS */

#endif /* VM_PRESSURE_H */
